/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PersistentByteMap {
    private MappedByteBuffer buf;
    private static final int MAGIC = 0;
    private static final int VERSION = 4;
    private static final int CAPACITY = 8;
    private static final int TABLE_BASE = 12;
    private static final int STRING_BASE = 16;
    private static final int STRING_SIZE = 20;
    private static final int FILE_SIZE = 24;
    private static final int ELEMENTS = 28;
    private static final int INT_SIZE = 4;
    private static final int TABLE_ENTRY_SIZE = 8;
    private int capacity;
    private int table_base;
    private int string_base;
    private int string_size;
    private int file_size;
    private int elements;
    private long length;
    private final File name;
    private static final int UNUSED_ENTRY = -1;
    public static final int KEYS = 0;
    public static final int VALUES = 1;
    public static final int ENTRIES = 2;
    private HashMap values;
    FileChannel fc;

    static /* synthetic */ int access$2(PersistentByteMap persistentByteMap, int n) {
        persistentByteMap.capacity = n;
        return persistentByteMap.capacity;
    }

    static /* synthetic */ int access$1(PersistentByteMap persistentByteMap, int n) {
        persistentByteMap.elements = n;
        return persistentByteMap.elements;
    }

    private PersistentByteMap(File file) {
        this.name = file;
    }

    public PersistentByteMap(String string, AccessMode accessMode) throws IOException {
        this(new File(string), accessMode);
    }

    public PersistentByteMap(File file, AccessMode accessMode) throws IOException {
        Object object;
        this.name = file;
        if (accessMode == AccessMode.READ_ONLY) {
            object = new FileInputStream(file);
            this.fc = ((FileInputStream)object).getChannel();
        } else {
            object = new RandomAccessFile(file, "rw");
            this.fc = ((RandomAccessFile)object).getChannel();
        }
        this.length = this.fc.size();
        this.buf = this.fc.map(accessMode.mapMode, 0L, this.length);
        int n = this.getWord(0);
        if (n != 1734568548) {
            throw new IllegalArgumentException(file.getName());
        }
        this.table_base = this.getWord(12);
        this.capacity = this.getWord(8);
        this.string_base = this.getWord(16);
        this.string_size = this.getWord(20);
        this.file_size = this.getWord(24);
        this.elements = this.getWord(28);
    }

    private void init(PersistentByteMap persistentByteMap, File file, int n, int n2) throws IOException {
        file.createNewFile();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        BigInteger bigInteger = new BigInteger(Integer.toString((n * 3 + 1) / 2));
        Object object = BigInteger.ONE.add(BigInteger.ONE);
        if (bigInteger.getLowestSetBit() != 0) {
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        while (!bigInteger.isProbablePrime(10)) {
            bigInteger = bigInteger.add((BigInteger)object);
        }
        this.capacity = n = bigInteger.intValue();
        this.table_base = 64;
        this.string_base = this.table_base + n * 8;
        this.string_size = 0;
        this.file_size = this.string_base;
        this.elements = 0;
        int n3 = this.string_base + n2;
        object = new byte[4096];
        for (long i = 0L; i < (long)n3; i += (long)4096) {
            randomAccessFile.write((byte[])object);
        }
        this.fc = randomAccessFile.getChannel();
        this.buf = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, randomAccessFile.length());
        for (int i = 0; i < n; ++i) {
            this.putKeyPos(-1, i);
        }
        this.putWord(1734568548, 0);
        this.putWord(1, 4);
        this.putWord(n, 8);
        this.putWord(this.table_base, 12);
        this.putWord(this.string_base, 16);
        this.putWord(this.file_size, 24);
        this.putWord(this.elements, 28);
        this.buf.force();
        this.length = this.fc.size();
        this.string_size = 0;
    }

    public static PersistentByteMap emptyPersistentByteMap(File file, int n, int n2) throws IOException {
        PersistentByteMap persistentByteMap = new PersistentByteMap(file);
        persistentByteMap.init(persistentByteMap, file, n, n2);
        return persistentByteMap;
    }

    private int getWord(int n) {
        this.buf.position(n);
        byte[] byArray = new byte[4];
        this.buf.get(byArray);
        int n2 = byArray[0] & 0xFF;
        n2 += (byArray[1] & 0xFF) << 8;
        n2 += (byArray[2] & 0xFF) << 16;
        return n2 += (byArray[3] & 0xFF) << 24;
    }

    private void putWord(int n, int n2) {
        this.buf.position(n2);
        byte[] byArray = new byte[]{(byte)n, (byte)(n >>> 8), (byte)(n >>> 16), (byte)(n >>> 24)};
        this.buf.put(byArray);
    }

    public Set entrySet() {
        return null;
    }

    private int getBucket(int n) {
        return this.table_base + 2 * n * 4;
    }

    private int getKeyPos(int n) {
        return this.getWord(this.getBucket(n));
    }

    private int getValuePos(int n) {
        return this.getWord(this.getBucket(n) + 4);
    }

    private void putKeyPos(int n, int n2) {
        this.putWord(n, this.getBucket(n2));
    }

    private void putValuePos(int n, int n2) {
        this.putWord(n, this.getBucket(n2) + 4);
    }

    private byte[] getBytes(int n) {
        int n2 = this.getWord(this.string_base + n);
        int n3 = this.string_base + n + 4;
        byte[] byArray = new byte[n2];
        this.buf.position(n3);
        this.buf.get(byArray, 0, n2);
        return byArray;
    }

    private int hash(byte[] byArray) {
        long l = ((long)byArray[0] & (long)255) + (((long)byArray[1] & (long)255) << 8) + (((long)byArray[2] & (long)255) << 16) + (((long)byArray[3] & (long)255) << 24);
        long l2 = l % (long)this.capacity;
        return (int)l2;
    }

    public byte[] get(byte[] byArray) {
        int n = this.hash(byArray);
        int n2;
        while ((n2 = this.getKeyPos(n)) != -1) {
            if (Arrays.equals(byArray, this.getBytes(n2))) {
                return this.getBytes(this.getValuePos(n));
            }
            ++n;
            n %= this.capacity;
        }
        return null;
    }

    public void put(byte[] byArray, byte[] byArray2) throws IllegalAccessException {
        int n = this.hash(byArray);
        if (this.elements >= this.capacity()) {
            throw new IllegalAccessException("Table Full: " + this.elements);
        }
        while (true) {
            int n2;
            if ((n2 = this.getKeyPos(n)) == -1) {
                int n3 = this.addBytes(byArray);
                this.putKeyPos(n3, n);
                int n4 = this.addBytes(byArray2);
                this.putValuePos(n4, n);
                ++this.elements;
                this.putWord(this.elements, 28);
                return;
            }
            if (Arrays.equals(byArray, this.getBytes(n2))) {
                int n5 = this.addBytes(byArray2);
                this.putValuePos(n5, n);
                return;
            }
            ++n;
            n %= this.capacity;
        }
    }

    private int addBytes(byte[] byArray) throws IllegalAccessException {
        int n;
        int n2;
        if (byArray.length > 16) {
            Object object;
            if (this.values == null) {
                this.values = new HashMap();
                for (int i = 0; i < this.capacity; ++i) {
                    if (this.getKeyPos(i) == -1) continue;
                    n2 = this.getValuePos(i);
                    ByteWrapper byteWrapper = new ByteWrapper(this, this.getBytes(n2));
                    this.values.put(byteWrapper, new Integer(n2));
                }
            }
            if ((object = this.values.get(new ByteWrapper(this, byArray))) != null) {
                return (Integer)object;
            }
        }
        if ((long)(byArray.length + 4) >= this.length) {
            throw new IllegalAccessException("String table Full");
        }
        n2 = n = this.string_base + this.string_size;
        this.putWord(byArray.length, n);
        this.buf.position(n += 4);
        this.buf.put(byArray, 0, byArray.length);
        n += byArray.length;
        n += 3;
        this.string_size = (n &= 0xFFFFFFFC) - this.string_base;
        this.file_size = n;
        this.putWord(this.string_size, 20);
        this.putWord(this.file_size, 24);
        if (byArray.length > 16) {
            this.values.put(new ByteWrapper(this, byArray), new Integer(n2 - this.string_base));
        }
        return n2 - this.string_base;
    }

    public Iterator iterator(int n) {
        return new HashIterator(this, n);
    }

    public int size() {
        return this.elements;
    }

    public int stringTableSize() {
        return this.string_size;
    }

    public int capacity() {
        return this.capacity * 2 / 3;
    }

    public void force() {
        this.buf.force();
    }

    public File getFile() {
        return this.name;
    }

    public void close() throws IOException {
        this.force();
        this.fc.close();
    }

    public void putAll(PersistentByteMap persistentByteMap) throws IllegalAccessException {
        if (this.elements == 0 && persistentByteMap.capacity == this.capacity && persistentByteMap.length == this.length) {
            this.buf.position(0);
            persistentByteMap.buf.position(0);
            this.buf.put(persistentByteMap.buf);
            this.table_base = persistentByteMap.table_base;
            this.string_base = persistentByteMap.string_base;
            this.string_size = persistentByteMap.string_size;
            this.file_size = persistentByteMap.file_size;
            this.elements = persistentByteMap.elements;
            if (persistentByteMap.values != null) {
                this.values = (HashMap)persistentByteMap.values.clone();
            }
            return;
        }
        Iterator iterator = persistentByteMap.iterator(2);
        while (iterator.hasNext()) {
            MapEntry mapEntry = (MapEntry)iterator.next();
            this.put((byte[])mapEntry.getKey(), (byte[])mapEntry.getValue());
        }
    }

    private final class ByteWrapper {
        private /* synthetic */ PersistentByteMap this$0;
        final byte[] bytes;
        final int hash;

        public ByteWrapper(PersistentByteMap persistentByteMap, byte[] byArray) {
            this.this$0 = persistentByteMap;
            int n = 0;
            this.bytes = byArray;
            for (int i = 0; i < byArray.length; ++i) {
                n += byArray[i];
            }
            this.hash = n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.bytes, ((ByteWrapper)object).bytes);
        }
    }

    public static final class MapEntry {
        private final Object key;
        private final Object value;
        private final int bucket;

        public MapEntry(int n, Object object, Object object2) {
            this.key = object;
            this.value = object2;
            this.bucket = n;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }

        public final int getBucket() {
            return this.bucket;
        }
    }

    private final class HashIterator
    implements Iterator {
        private /* synthetic */ PersistentByteMap this$0;
        private int idx;
        private int count;
        private final int type;

        HashIterator(PersistentByteMap persistentByteMap, int n) {
            this.this$0 = persistentByteMap;
            this.type = n;
            this.count = persistentByteMap.elements;
            this.idx = 0;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            --this.count;
            for (int i = this.idx; i < this.this$0.capacity; ++i) {
                if (this.this$0.getKeyPos(i) == -1) continue;
                this.idx = i + 1;
                if (this.type == 1) {
                    return this.this$0.getBytes(this.this$0.getValuePos(i));
                }
                if (this.type == 0) {
                    return this.this$0.getBytes(this.this$0.getKeyPos(i));
                }
                return new MapEntry(i, this.this$0.getBytes(this.this$0.getKeyPos(i)), this.this$0.getBytes(this.this$0.getValuePos(i)));
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class AccessMode {
        private final FileChannel.MapMode mapMode;
        public static final AccessMode READ_ONLY = new AccessMode(FileChannel.MapMode.READ_ONLY);
        public static final AccessMode READ_WRITE = new AccessMode(FileChannel.MapMode.READ_WRITE);
        public static final AccessMode PRIVATE = new AccessMode(FileChannel.MapMode.PRIVATE);

        AccessMode(FileChannel.MapMode mapMode) {
            this.mapMode = mapMode;
        }
    }
}

