module Examples.Tutorial.Stream where

import qualified Prelude
import Feldspar
import Feldspar.Stream hiding (fir,iir)
import Feldspar.Vector (Vector, DVector
                       , replicate, length, scalarProd, reverse, vector)

fir :: DVector Float ->
       Stream (Data Float) -> Stream (Data Float)
fir b input =
    recurrenceI (replicate (length b) 0) input
                (\input -> scalarProd b (reverse input))

iir :: Data Float -> DVector Float -> DVector Float ->
       Stream (Data Float) -> Stream (Data Float)
iir a0 a b input =
    recurrenceIO (replicate (length b) 0) input
                 (replicate (length a) 0)
      (\input output -> 1 / a0 *
                        ( scalarProd b (reverse input)
                        - scalarProd a (reverse output))
      )
