module Examples.Simple.Matrices where

import qualified Prelude
import Feldspar
import Feldspar.Vector
import Feldspar.Matrix
import Feldspar.Compiler

-- * Examples on working with matrices.

-- | Generates a parallel matrix.
matrix1 :: Matrix Index
matrix1 = indexed 2 vec
  where
    vec x = indexed 10 ((+x) . (*10))

-- | Generates a parallel matrix (20x100) and transposes it.
matrix2 :: Matrix Index
matrix2 = transpose $ indexed 20 (\x -> indexed 100 ((+x) . (*10)))

-- | Matrix multiplication
matMult ::  Data' (D16,D16) [[Int32]] -> Data' (D16,D16) [[Int32]] -> Data [[Int32]]
matMult = wrap ((***) :: Matrix Int32 -> Matrix Int32 -> Matrix Int32)

matMult' :: Data [[Int32]] -> Data [[Int32]] -> Data [[Int32]]
matMult' m1 m2 = freezeMatrix $ (unfreezeMatrix' 16 16 m1) *** (unfreezeMatrix' 16 16 m2)
