module Examples.Math.Convolution where

import qualified Prelude
import Feldspar
import Feldspar.Vector
import Feldspar.Compiler
import Feldspar.Matrix

-- | Generic (not compilable) convolution function
convolution :: (Numeric a) => DVector a -> DVector a -> DVector a
convolution kernel input = map ((scalarProd kernel) . reverse) $ inits input

-- | Wrappers to define the size and element type of vectors in 'convolution'
convolutionInstance :: Data [Float] -> Data [Float] -> Data [Float]
convolutionInstance kernel input = freezeVector $ convolution kernel' input'
    where
        input'  = unfreezeVector' 256 input
        kernel' = unfreezeVector'  16 kernel

-- | Wrappers to define the size and element type of vectors in 'convolution'
convolution_wrapped :: Data' D16 [Float] ->  Data' D256 [Float] ->  Data [Float]
convolution_wrapped = wrap (convolution :: DVector Float -> DVector Float -> DVector Float)