/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.SVNTeamProvider;
import org.tigris.subversion.subclipse.core.commands.CheckoutCommand;
import org.tigris.subversion.subclipse.core.repo.SVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;

public class SVNProjectSetCapability
extends ProjectSetCapability {
    public String[] asReference(IProject[] projects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        String[] result = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            result[i] = this.asReference(projects[i]);
            ++i;
        }
        return result;
    }

    private String asReference(IProject project) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("0.9.3,");
        SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)project);
        SVNWorkspaceRoot root = provider.getSVNWorkspaceRoot();
        buffer.append(root.getLocalRoot().getUrl().toString());
        buffer.append(",");
        buffer.append(project.getName());
        return buffer.toString();
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        Policy.checkCanceled(monitor);
        HashMap infoMap = new HashMap(referenceStrings.length);
        IProject[] projects = this.asProjects(context, referenceStrings, infoMap);
        projects = this.confirmOverwrite(context, projects);
        if (projects == null) {
            return new IProject[0];
        }
        return this.checkout(projects, infoMap, monitor);
    }

    private IProject[] asProjects(ProjectSetSerializationContext context, String[] referenceStrings, Map infoMap) throws SVNException {
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < referenceStrings.length) {
            StringTokenizer tokenizer = new StringTokenizer(referenceStrings[i], ",");
            String version = tokenizer.nextToken();
            if (version.equals("0.9.3")) {
                LoadInfo info = new LoadInfo(context, tokenizer);
                IProject proj = info.getProject();
                result.add(proj);
                infoMap.put(proj, info);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IProject[] checkout(IProject[] projects, Map infoMap, IProgressMonitor monitor) throws TeamException {
        if (projects == null) return new IProject[0];
        if (projects.length == 0) {
            return new IProject[0];
        }
        ISchedulingRule rule = projects[0].getWorkspace().getRuleFactory().modifyRule((IResource)projects[0]);
        Job.getJobManager().beginRule(rule, monitor);
        monitor.beginTask("", 1000 * projects.length);
        ArrayList<IProject> result = new ArrayList<IProject>();
        try {
            int i = 0;
            while (i < projects.length && !monitor.isCanceled()) {
                IProject project = projects[i];
                LoadInfo info = (LoadInfo)infoMap.get(project);
                if (info != null && info.checkout((IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                    result.add(project);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            Job.getJobManager().endRule(rule);
            monitor.done();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        Job.getJobManager().endRule(rule);
        monitor.done();
        return result.toArray(new IProject[result.size()]);
    }

    protected static class LoadInfo {
        private final ISVNRepositoryLocation repositoryLocation;
        private final IProject project;
        private final boolean fromFileSystem;
        private final String directory;

        LoadInfo(ProjectSetSerializationContext context, StringTokenizer tokenizer) throws SVNException {
            String repo = tokenizer.nextToken();
            String projectName = tokenizer.nextToken();
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (repo.indexOf("://") != -1) {
                this.repositoryLocation = SVNRepositoryLocation.fromString(repo);
                this.fromFileSystem = false;
                this.directory = null;
            } else {
                this.repositoryLocation = null;
                this.fromFileSystem = true;
                if (!new Path(repo).isAbsolute()) {
                    String baseDir = context.getFilename() != null ? new File(context.getFilename()).getParent() : this.project.getWorkspace().getRoot().getLocation().toOSString();
                    try {
                        this.directory = new File(String.valueOf(baseDir) + File.separatorChar + repo).getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        throw new SVNException("Path expansion/canonicalization failed", ioe);
                    }
                } else {
                    this.directory = repo;
                }
            }
        }

        protected IProject getProject() {
            return this.project;
        }

        boolean checkout(IProgressMonitor monitor) throws TeamException {
            if (this.fromFileSystem) {
                return this.importExistingProject(monitor);
            }
            if (this.repositoryLocation == null) {
                return false;
            }
            CheckoutCommand command = new CheckoutCommand(new ISVNRemoteFolder[]{this.repositoryLocation.getRootFolder()}, new IProject[]{this.project});
            command.run(monitor);
            return true;
        }

        boolean importExistingProject(IProgressMonitor monitor) throws TeamException {
            if (this.directory == null) {
                return false;
            }
            try {
                monitor.beginTask("Importing", 3000);
                this.createExistingProject((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                monitor.subTask("Refreshing " + this.project.getName());
                RepositoryProvider.map((IProject)this.project, (String)SVNProviderPlugin.getTypeId());
                monitor.worked(1000);
                SVNWorkspaceRoot.setSharing(this.project, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                Object var3_2 = null;
            }
            catch (CoreException ce) {
                try {
                    throw new SVNException("Failed to import External SVN Project" + (Object)((Object)ce), ce);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return true;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void createExistingProject(IProgressMonitor monitor) throws CoreException {
            String projectName = this.project.getName();
            try {
                monitor.beginTask("Creating " + projectName, 2000);
                IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(this.directory) + File.separatorChar + ".project"));
                description.setName(projectName);
                this.project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                this.project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                monitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            monitor.done();
        }
    }
}

