/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.CharOperation;
import org.rubypeople.rdt.internal.core.util.SimpleWordSet;

public class Util {
    protected static ResourceBundle bundle;
    private static boolean ENABLE_RUBY_LIKE_EXTENSIONS;
    private static char[][] RUBY_LIKE_EXTENSIONS;
    private static char[][] RUBY_LIKE_FILENAMES;
    private static final String bundleName = "org.rubypeople.rdt.internal.core.util.messages";
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;
    private static final int DEFAULT_READING_SIZE = 8192;
    private static char[][] names;

    static {
        ENABLE_RUBY_LIKE_EXTENSIONS = true;
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
        Util.relocalize();
    }

    private Util() {
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public static String bind(String string) {
        return Util.bind(string, null);
    }

    public static String bind(String string, String[] stringArray) {
        StringBuffer stringBuffer;
        block17: {
            if (string == null) {
                return "No message available";
            }
            String string2 = null;
            try {
                string2 = bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return "Missing message: " + string + " in: " + bundleName;
            }
            char[] cArray = CharOperation.replace(string2.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (stringArray == null) {
                return new String(cArray);
            }
            int n = cArray.length;
            int n2 = 0;
            int n3 = n;
            stringBuffer = null;
            while ((n3 = CharOperation.indexOf('{', cArray, n2)) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n + stringArray.length * 20);
                }
                stringBuffer.append(cArray, n2, n3 - n2);
                n2 = CharOperation.indexOf('}', cArray, n3 + 1);
                if (n2 > -1) {
                    int n4 = -1;
                    String string3 = new String(cArray, n3 + 1, n2 - n3 - 1);
                    try {
                        n4 = Integer.parseInt(string3);
                        if (stringArray[n4] == null) {
                            stringBuffer.append('{').append(string3).append('}');
                        } else {
                            stringBuffer.append(stringArray[n4]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        boolean bl = false;
                        if (!string.equals(string3)) {
                            String string4 = null;
                            try {
                                string4 = bundle.getString(string3);
                                stringBuffer.append(string4);
                                bl = true;
                            }
                            catch (MissingResourceException missingResourceException) {}
                        }
                        if (!bl) {
                            stringBuffer.append(cArray, n3 + 1, n2 - n3);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        stringBuffer.append("{missing " + Integer.toString(n4) + "}");
                    }
                    ++n2;
                    continue;
                }
                stringBuffer.append(cArray, n3, n);
                break block17;
            }
            if (stringBuffer == null) {
                return new String(cArray);
            }
            stringBuffer.append(cArray, n2, n - n2);
        }
        return stringBuffer.toString();
    }

    public static String bind(String string, String string2) {
        return Util.bind(string, new String[]{string2});
    }

    public static String bind(String string, String string2, String string3) {
        return Util.bind(string, new String[]{string2, string3});
    }

    public static final boolean isExcluded(IPath iPath, char[][] cArray, char[][] cArray2, boolean bl) {
        if (cArray == null && cArray2 == null) {
            return false;
        }
        return Util.isExcluded(iPath.toString().toCharArray(), cArray, cArray2, bl);
    }

    public static final boolean isExcluded(IResource iResource, char[][] cArray, char[][] cArray2) {
        IPath iPath = iResource.getFullPath();
        return Util.isExcluded(iPath, cArray, cArray2, iResource.getType() == 2);
    }

    public static final boolean isExcluded(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl) {
        int n;
        int n2;
        block9: {
            if (cArray2 == null && cArray3 == null) {
                return false;
            }
            if (cArray2 != null) {
                n2 = 0;
                n = cArray2.length;
                while (n2 < n) {
                    int n3;
                    int n4;
                    char[] cArray4;
                    char[] cArray5 = cArray4 = cArray2[n2];
                    if (bl && (n4 = CharOperation.lastIndexOf('/', cArray4)) != -1 && n4 != cArray4.length - 1 && ((n3 = CharOperation.indexOf('*', cArray4, n4)) == -1 || n3 >= cArray4.length - 1 || cArray4[n3 + 1] != '*')) {
                        cArray5 = CharOperation.subarray(cArray4, 0, n4);
                    }
                    if (!CharOperation.pathMatch(cArray5, cArray, true, '/')) {
                        ++n2;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (bl) {
            cArray = CharOperation.concat(cArray, new char[]{'*'}, '/');
        }
        if (cArray3 != null) {
            n2 = 0;
            n = cArray3.length;
            while (n2 < n) {
                if (CharOperation.pathMatch(cArray3[n2], cArray, true, '/')) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static void verbose(String string) {
        Util.verbose(string, System.out);
    }

    public static synchronized void verbose(String string, PrintStream printStream) {
        int n;
        int n2 = 0;
        do {
            n = string.indexOf(10, n2);
            printStream.print(Thread.currentThread());
            printStream.print(" ");
            printStream.print(string.substring(n2, n == -1 ? string.length() : n + 1));
        } while ((n2 = n + 1) != 0);
        printStream.println();
    }

    public static final boolean isRubyLikeFileName(String string) {
        if (string == null) {
            return false;
        }
        char[][] cArray = Util.getRubyLikeFilenames();
        int n = 0;
        while (n < cArray.length) {
            char[] cArray2 = cArray[n];
            if (string.equals(new String(cArray2))) {
                return true;
            }
            ++n;
        }
        return Util.indexOfRubyLikeExtension(string) != -1;
    }

    public static boolean isValidRubyScriptName(String string) {
        return RubyConventions.validateRubyScriptName(string).getSeverity() != 4;
    }

    public static boolean equalArraysOrNull(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (n != objectArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] == null ? objectArray2[n2] != null : !objectArray[n2].equals(objectArray2[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void log(Throwable throwable, String string) {
        Throwable throwable2;
        if (throwable instanceof RubyModelException && (throwable2 = ((RubyModelException)((Object)throwable)).getException()) != null) {
            throwable = throwable2;
        }
        Status status = new Status(4, "org.rubypeople.rdt.core", 4, string, throwable);
        RubyCore.getPlugin().getLog().log((IStatus)status);
    }

    public static int combineHashCodes(int n, int n2) {
        return n * 17 + n2;
    }

    public static final boolean isExcluded(IRubyElement iRubyElement) {
        int n = iRubyElement.getElementType();
        switch (n) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                IResource iResource = iRubyElement.getResource();
                if (iResource == null) {
                    return false;
                }
                return Util.isExcluded(iRubyElement.getParent());
            }
        }
        IRubyElement iRubyElement2 = iRubyElement.getAncestor(2);
        return iRubyElement2 != null && Util.isExcluded(iRubyElement2);
    }

    public static String getNameWithoutRubyLikeExtension(String string) {
        int n = Util.indexOfRubyLikeExtension(string);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static int indexOfRubyLikeExtension(String string) {
        int n = string.length();
        char[][] cArray = Util.getRubyLikeExtensions();
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            block4: {
                char[] cArray2 = cArray[n2];
                int n4 = cArray2.length;
                int n5 = n - n4;
                int n6 = n5 - 1;
                if (n6 >= 0 && string.charAt(n6) == '.') {
                    int n7 = 0;
                    while (n7 < n4) {
                        if (string.charAt(n5 + n7) == cArray2[n7]) {
                            ++n7;
                            continue;
                        }
                        break block4;
                    }
                    return n6;
                }
            }
            ++n2;
        }
        return -1;
    }

    public static char[][] getRubyLikeExtensions() {
        if (RUBY_LIKE_EXTENSIONS == null) {
            if (!ENABLE_RUBY_LIKE_EXTENSIONS) {
                RUBY_LIKE_EXTENSIONS = new char[][]{"rb".toCharArray(), "rbw".toCharArray(), "rjs".toCharArray(), "rxml".toCharArray()};
            } else {
                IContentType iContentType = Platform.getContentTypeManager().getContentType("org.rubypeople.rdt.core.rubySource");
                String[] stringArray = iContentType == null ? null : iContentType.getFileSpecs(8);
                int n = stringArray == null ? 0 : stringArray.length;
                char[][] cArray = new char[n][];
                SimpleWordSet simpleWordSet = new SimpleWordSet(n);
                cArray[0] = "rb".toCharArray();
                simpleWordSet.add(cArray[0]);
                int n2 = 1;
                int n3 = 0;
                while (n3 < n) {
                    String string = stringArray[n3];
                    char[] cArray2 = string.toCharArray();
                    if (!simpleWordSet.includes(cArray2)) {
                        cArray[n2++] = cArray2;
                        simpleWordSet.add(cArray2);
                    }
                    ++n3;
                }
                if (n2 != n) {
                    char[][] cArray3 = cArray;
                    cArray = new char[n2][];
                    System.arraycopy(cArray3, 0, cArray, 0, n2);
                }
                RUBY_LIKE_EXTENSIONS = cArray;
            }
        }
        return RUBY_LIKE_EXTENSIONS;
    }

    public static char[][] getRubyLikeFilenames() {
        if (RUBY_LIKE_FILENAMES == null) {
            IContentType iContentType = Platform.getContentTypeManager().getContentType("org.rubypeople.rdt.core.rubySource");
            String[] stringArray = iContentType == null ? null : iContentType.getFileSpecs(4);
            int n = stringArray == null ? 0 : stringArray.length;
            names = new char[n][];
            SimpleWordSet simpleWordSet = new SimpleWordSet(n);
            Util.names[0] = "Rakefile".toCharArray();
            simpleWordSet.add(names[0]);
            int n2 = 1;
            int n3 = 0;
            while (n3 < n) {
                String string = stringArray[n3];
                char[] cArray = string.toCharArray();
                if (!simpleWordSet.includes(cArray)) {
                    Util.names[n2++] = cArray;
                    simpleWordSet.add(cArray);
                }
                ++n3;
            }
            if (n2 != n) {
                char[][] cArray = names;
                names = new char[n2][];
                System.arraycopy(cArray, 0, names, 0, n2);
            }
            RUBY_LIKE_FILENAMES = names;
        }
        return RUBY_LIKE_FILENAMES;
    }

    public static char[] getResourceContentsAsCharArray(IFile iFile) throws RubyModelException {
        String string = null;
        try {
            string = iFile.getCharset();
        }
        catch (CoreException coreException) {}
        return Util.getResourceContentsAsCharArray(iFile, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getResourceContentsAsCharArray(IFile iFile, String string) throws RubyModelException {
        char[] cArray;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(iFile.getContents(true));
        }
        catch (CoreException coreException) {
            throw new RubyModelException(coreException, 969);
        }
        try {
            try {
                cArray = Util.getInputStreamAsCharArray(bufferedInputStream, -1, string);
                Object var4_6 = null;
            }
            catch (IOException iOException) {
                throw new RubyModelException(iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        ((InputStream)bufferedInputStream).close();
        return cArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n == -1) {
            int n2;
            cArray = new char[]{};
            int n3 = 0;
            int n4 = -1;
            do {
                if (n3 + (n2 = Math.max(inputStream.available(), 8192)) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n3 + n2];
                    System.arraycopy(cArray2, 0, cArray, 0, n3);
                }
                if ((n4 = inputStreamReader.read(cArray, n3, n2)) <= 0) continue;
                n3 += n4;
            } while (n4 != -1);
            n2 = 0;
            if (n3 > 0 && "UTF-8".equals(string) && cArray[0] == '\ufeff') {
                --n3;
                n2 = 1;
            }
            if (n3 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n3];
                System.arraycopy(cArray3, n2, cArray, 0, n3);
            }
        } else {
            cArray = new char[n];
            int n5 = 0;
            int n6 = 0;
            while (n6 != -1 && n5 != n) {
                n6 = inputStreamReader.read(cArray, n5 += n6, n - n5);
            }
            int n7 = 0;
            if (n > 0 && "UTF-8".equals(string) && cArray[0] == '\ufeff') {
                --n5;
                n7 = 1;
            }
            if (n5 != n) {
                char[] cArray4 = cArray;
                cArray = new char[n5];
                System.arraycopy(cArray4, n7, cArray, 0, n5);
            }
        }
        return cArray;
    }

    public static void resetRubyLikeExtensions() {
        RUBY_LIKE_EXTENSIONS = null;
        RUBY_LIKE_FILENAMES = null;
    }
}

