/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIException;
import org.rubypeople.rdt.internal.ui.RubyUIStatus;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesAccess;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    private static final String PREF_FORMATTER_PROFILES = "org.eclipse.jdt.ui.formatterprofiles";
    private static final String PREF_FORMATTER_PROFILES_VERSION = "org.eclipse.jdt.ui.formatterprofiles.version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";

    private ProfileStore() {
    }

    public static List readProfiles(IScopeContext iScopeContext) throws CoreException {
        List list = ProfileStore.readProfilesFromPreferences(PREF_FORMATTER_PROFILES, iScopeContext);
        if (list == null) {
            return ProfileStore.readOldForCompatibility(iScopeContext);
        }
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProfiles(Collection collection, IScopeContext iScopeContext) throws CoreException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        try {
            String string;
            ProfileStore.writeProfilesToStream(collection, byteArrayOutputStream);
            try {
                string = byteArrayOutputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = byteArrayOutputStream.toString();
            }
            IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.ui");
            iEclipsePreferences.put(PREF_FORMATTER_PROFILES, string);
            iEclipsePreferences.putInt(PREF_FORMATTER_PROFILES_VERSION, 1);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        byteArrayOutputStream.close();
    }

    private static List readProfilesFromPreferences(String string, IScopeContext iScopeContext) throws CoreException {
        String string2 = iScopeContext.getNode("org.rubypeople.rdt.ui").get(string, null);
        if (string2 != null && string2.length() > 0) {
            List list;
            byte[] byArray;
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string2.getBytes();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                List list2 = ProfileStore.readProfilesFromStream(new InputSource(byteArrayInputStream));
                if (list2 != null) {
                    int n = 0;
                    while (n < list2.size()) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)list2.get(n));
                        ++n;
                    }
                }
                list = list2;
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)byteArrayInputStream).close();
            }
            catch (IOException iOException) {}
            return list;
        }
        return null;
    }

    private static List readOldForCompatibility(IScopeContext iScopeContext) {
        File file = RubyPlugin.getDefault().getStateLocation().append("code_formatter_profiles.xml").toFile();
        if (!file.exists()) {
            return null;
        }
        try {
            List list;
            FileReader fileReader = new FileReader(file);
            try {
                List list2 = ProfileStore.readProfilesFromStream(new InputSource(fileReader));
                if (list2 != null) {
                    int n = 0;
                    while (n < list2.size()) {
                        ProfileVersioner.updateAndComplete((ProfileManager.CustomProfile)list2.get(n));
                        ++n;
                    }
                    ProfileStore.writeProfiles(list2, iScopeContext);
                }
                file.delete();
                list = list2;
                Object var5_8 = null;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                fileReader.close();
                throw throwable;
            }
            fileReader.close();
            return list;
        }
        catch (CoreException coreException) {
            RubyPlugin.log(coreException);
        }
        catch (IOException iOException) {
            RubyPlugin.log(iOException);
        }
        return null;
    }

    public static List readProfilesFromFile(File file) throws CoreException {
        try {
            List list;
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                list = ProfileStore.readProfilesFromStream(new InputSource(fileInputStream));
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            return list;
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
    }

    private static List readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler profileDefaultHandler = new ProfileDefaultHandler();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)profileDefaultHandler);
        }
        catch (SAXException sAXException) {
            throw ProfileStore.createException(sAXException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ProfileStore.createException(parserConfigurationException, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        return profileDefaultHandler.getProfiles();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeProfilesToFile(Collection collection, File file) throws CoreException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(collection, fileOutputStream);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    ((OutputStream)fileOutputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var3_5 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                ((OutputStream)fileOutputStream).close();
                return;
            }
        }
        catch (IOException iOException) {
            throw ProfileStore.createException(iOException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static void writeProfilesToStream(Collection collection, OutputStream outputStream) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(XML_NODE_ROOT);
            element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(1));
            document.appendChild(element);
            Object object = collection.iterator();
            while (object.hasNext()) {
                ProfileManager.Profile profile = (ProfileManager.Profile)object.next();
                if (!profile.isProfileToSave()) continue;
                Element element2 = ProfileStore.createProfileElement(profile, document);
                element.appendChild(element2);
            }
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).setOutputProperty("method", "xml");
            ((Transformer)object).setOutputProperty("encoding", "UTF-8");
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException transformerException) {
            throw ProfileStore.createException(transformerException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw ProfileStore.createException(parserConfigurationException, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        Iterator iterator = ProfileManager.getKeys().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)profile.getSettings().get(string);
            if (string2 != null) {
                Element element2 = document.createElement(XML_NODE_SETTING);
                element2.setAttribute(XML_ATTRIBUTE_ID, string);
                element2.setAttribute(XML_ATTRIBUTE_VALUE, string2);
                element.appendChild(element2);
                continue;
            }
            RubyPlugin.logErrorMessage("ProfileStore: Profile does not contain value for key " + string);
        }
        return element;
    }

    public static void checkCurrentOptionsVersion() {
        PreferencesAccess preferencesAccess = PreferencesAccess.getOriginalPreferences();
        IScopeContext iScopeContext = preferencesAccess.getInstanceScope();
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.ui");
        int n = iEclipsePreferences.getInt(PREF_FORMATTER_PROFILES_VERSION, 0);
        if (n >= 1) {
            return;
        }
        try {
            ProfileManager profileManager;
            List list = ProfileStore.readProfiles(iScopeContext);
            if (list == null) {
                list = Collections.EMPTY_LIST;
            }
            if ((profileManager = new ProfileManager(list, iScopeContext, preferencesAccess)).getSelected() instanceof ProfileManager.CustomProfile) {
                profileManager.commitChanges(iScopeContext);
            }
            iEclipsePreferences.putInt(PREF_FORMATTER_PROFILES_VERSION, 1);
            ProfileStore.savePreferences(iScopeContext);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n2 = 0;
            while (n2 < iProjectArray.length) {
                IScopeContext iScopeContext2 = preferencesAccess.getProjectScope(iProjectArray[n2]);
                if (ProfileManager.hasProjectSpecificSettings(iScopeContext2)) {
                    profileManager = new ProfileManager(list, iScopeContext2, preferencesAccess);
                    profileManager.commitChanges(iScopeContext2);
                    ProfileStore.savePreferences(iScopeContext2);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            RubyPlugin.log(coreException);
        }
        catch (BackingStoreException backingStoreException) {
            RubyPlugin.log(backingStoreException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void savePreferences(IScopeContext iScopeContext) throws BackingStoreException {
        try {
            iScopeContext.getNode("org.rubypeople.rdt.ui").flush();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            iScopeContext.getNode("org.rubypeople.rdt.core").flush();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        iScopeContext.getNode("org.rubypeople.rdt.core").flush();
    }

    private static RubyUIException createException(Throwable throwable, String string) {
        return new RubyUIException(RubyUIStatus.createError(4, string, throwable));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List fProfiles;
        private int fVersion;
        private String fName;
        private Map fSettings;

        ProfileDefaultHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals(ProfileStore.XML_NODE_SETTING)) {
                String string4 = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String string5 = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(string4, string5);
            } else if (string3.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fSettings = new HashMap(200);
            } else if (string3.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList();
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXException(numberFormatException);
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (string3.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings, this.fVersion));
                this.fName = null;
                this.fSettings = null;
            }
        }

        public List getProfiles() {
            return this.fProfiles;
        }
    }
}

