/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.corext.util;

import java.util.Map;
import org.eclipse.text.edits.TextEdit;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.ToolFactory;
import org.rubypeople.rdt.internal.corext.Assert;

public class CodeFormatterUtil {
    public static TextEdit format2(int n, String string, int n2, int n3, int n4, String string2, Map map) {
        if (n2 < 0 || n3 < 0 || n2 + n3 > string.length()) {
            throw new IllegalArgumentException("offset or length outside of string. offset: " + n2 + ", length: " + n3 + ", string size: " + string.length());
        }
        return ToolFactory.createCodeFormatter((Map)map).format(n, string, n2, n3, n4, string2);
    }

    public static int getIndentWidth(IRubyProject iRubyProject) {
        String string = "mixed".equals(CodeFormatterUtil.getCoreOption(iRubyProject, "org.rubypeople.rdt.core.formatter.tabulation.char")) ? "org.rubypeople.rdt.core.formatter.indentation.size" : "org.rubypeople.rdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(iRubyProject, string, 4);
    }

    public static int getTabWidth(IRubyProject iRubyProject) {
        String string = "space".equals(CodeFormatterUtil.getCoreOption(iRubyProject, "org.rubypeople.rdt.core.formatter.tabulation.char")) ? "org.rubypeople.rdt.core.formatter.indentation.size" : "org.rubypeople.rdt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(iRubyProject, string, 4);
    }

    private static String getCoreOption(IRubyProject iRubyProject, String string) {
        if (iRubyProject == null) {
            return RubyCore.getOption((String)string);
        }
        return iRubyProject.getOption(string, true);
    }

    private static int getCoreOption(IRubyProject iRubyProject, String string, int n) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(iRubyProject, string));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static String createIndentString(int n, IRubyProject iRubyProject) {
        int n2;
        int n3;
        int n4;
        String string = CodeFormatterUtil.getCoreOption(iRubyProject, "org.rubypeople.rdt.core.formatter.tabulation.char");
        if ("space".equals(string)) {
            n4 = 0;
            n3 = n * CodeFormatterUtil.getIndentWidth(iRubyProject);
        } else if ("tab".equals(string)) {
            n4 = n;
            n3 = 0;
        } else if ("mixed".equals(string)) {
            int n5 = CodeFormatterUtil.getTabWidth(iRubyProject);
            n2 = n * CodeFormatterUtil.getIndentWidth(iRubyProject);
            if (n5 > 0) {
                n4 = n2 / n5;
                n3 = n2 % n5;
            } else {
                n4 = 0;
                n3 = n2;
            }
        } else {
            Assert.isTrue(false);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n4 + n3);
        n2 = 0;
        while (n2 < n4) {
            stringBuffer.append('\t');
            ++n2;
        }
        n2 = 0;
        while (n2 < n3) {
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static TextEdit format2(int n, String string, int n2, String string2, Map map) {
        return CodeFormatterUtil.format2(n, string, 0, string.length(), n2, string2, map);
    }
}

