/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.views;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.testunit.views.FailureTrace;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;

public class CopyTraceAction
extends Action {
    private FailureTrace fView;
    private final Clipboard fClipboard;

    public CopyTraceAction(FailureTrace failureTrace, Clipboard clipboard) {
        super(TestUnitMessages.getString("CopyTrace.action.label"));
        Assert.isNotNull((Object)clipboard);
        this.fView = failureTrace;
        this.fClipboard = clipboard;
    }

    public void run() {
        block4: {
            String string = this.fView.getTrace();
            if (string == null) {
                string = "";
            }
            TextTransfer textTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{this.convertLineTerminators(string)}, new Transfer[]{textTransfer});
            }
            catch (SWTError sWTError) {
                if (sWTError.code != 2002) {
                    throw sWTError;
                }
                if (!MessageDialog.openQuestion((Shell)this.fView.getComposite().getShell(), (String)TestUnitMessages.getString("CopyTraceAction.problem"), (String)TestUnitMessages.getString("CopyTraceAction.clipboard_busy"))) break block4;
                this.run();
            }
        }
    }

    private String convertLineTerminators(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                printWriter.println(string2);
            }
        }
        catch (IOException iOException) {
            return string;
        }
        return stringWriter.toString();
    }
}

