/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.testunit.launcher;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.util.RubyFileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;
import org.rubypeople.rdt.testunit.launcher.TestSearchEngine;
import org.rubypeople.rdt.testunit.views.TestUnitMessages;
import org.rubypeople.rdt.ui.RubyElementLabelProvider;

public class RubyClassSelector {
    protected static final String EMPTY_STRING = "";
    private Composite composite;
    private Button browseButton;
    private Text textField;
    protected String browseDialogMessage = "";
    protected String browseDialogTitle = "";
    protected String validatedSelectionText = "";
    private RubyFileSelector fileSelector;
    private RubyProjectSelector projectSelector;

    public RubyClassSelector(Composite composite, RubyFileSelector rubyFileSelector, RubyProjectSelector rubyProjectSelector) {
        this.fileSelector = rubyFileSelector;
        this.projectSelector = rubyProjectSelector;
        this.composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.textField = new Text(this.composite, 2052);
        this.textField.setLayoutData((Object)new GridData(768));
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubyClassSelector.this.validatedSelectionText = RubyClassSelector.this.validateResourceSelection();
            }
        });
        this.browseButton = new Button(this.composite, 8);
        this.browseButton.setText("Search...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RubyClassSelector.this.handleBrowseSelected();
            }
        });
        this.browseDialogTitle = TestUnitMessages.getString("RubyClassSelector.Title");
    }

    protected void handleBrowseSelected() {
        Object[] objectArray = this.getTypesInSelectedFile();
        if (objectArray == null) {
            objectArray = this.getTypesInSelectedProject();
        }
        if (objectArray == null) {
            objectArray = this.getAllTypes();
        }
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new RubyElementLabelProvider());
        elementListSelectionDialog.setElements(objectArray);
        elementListSelectionDialog.setTitle(this.browseDialogTitle);
        elementListSelectionDialog.setMessage(this.browseDialogMessage);
        elementListSelectionDialog.setMultipleSelection(false);
        if (elementListSelectionDialog.open() == 0) {
            this.textField.setText(((IRubyElement)elementListSelectionDialog.getFirstResult()).getElementName());
        }
    }

    private IRubyElement[] getTypesInSelectedProject() {
        IProject iProject = this.projectSelector.getSelection();
        if (iProject == null) {
            return null;
        }
        return TestSearchEngine.findTests(iProject);
    }

    private IRubyElement[] getTypesInSelectedFile() {
        String string = this.fileSelector.getValidatedSelectionText();
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        IProject iProject = this.projectSelector.getSelection();
        if (iProject == null) {
            return null;
        }
        IFile iFile = iProject.getFile(string);
        return TestSearchEngine.findTests(iFile);
    }

    private IRubyElement[] getAllTypes() {
        ArrayList<IRubyElement> arrayList = new ArrayList<IRubyElement>();
        IProject[] iProjectArray = RubyCore.getRubyProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IRubyElement[] iRubyElementArray = TestSearchEngine.findTests(iProjectArray[n]);
            arrayList.addAll(Arrays.asList(iRubyElementArray));
            ++n;
        }
        IRubyElement[] iRubyElementArray = new IRubyElement[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, iRubyElementArray, 0, iRubyElementArray.length);
        return iRubyElementArray;
    }

    protected String validateResourceSelection() {
        String string = this.textField.getText();
        return string == null ? EMPTY_STRING : string;
    }

    protected Shell getShell() {
        return this.composite.getShell();
    }

    public void setLayoutData(Object object) {
        this.composite.setLayoutData(object);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.textField.addModifyListener(modifyListener);
    }

    public void setBrowseDialogMessage(String string) {
        this.browseDialogMessage = string;
    }

    public void setBrowseDialogTitle(String string) {
        this.browseDialogTitle = string;
    }

    public void setEnabled(boolean bl) {
        this.composite.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    public String getSelectionText() {
        return this.textField.getText();
    }

    public String getValidatedSelectionText() {
        return this.validatedSelectionText;
    }

    public void setSelectionText(String string) {
        this.textField.setText(string);
    }
}

