/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.conflict;

import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.conflict.AbstractConflictManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class FixedConflictManager
extends AbstractConflictManager {
    private Collection _revs;

    public FixedConflictManager(String[] revs) {
        this._revs = Arrays.asList(revs);
        this.setName("fixed" + this._revs);
    }

    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        ArrayList<IvyNode> resolved = new ArrayList<IvyNode>(conflicts.size());
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            String revision = node.getResolvedId().getRevision();
            if (!this._revs.contains(revision)) continue;
            resolved.add(node);
        }
        return resolved;
    }

    public Collection getRevs() {
        return this._revs;
    }
}

