/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.ram;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.ram.RamFileData;
import org.apache.commons.vfs.provider.ram.RamFileOutputStream;
import org.apache.commons.vfs.provider.ram.RamFileRandomAccessContent;
import org.apache.commons.vfs.provider.ram.RamFileSystem;
import org.apache.commons.vfs.provider.ram.RamFileSystemConfigBuilder;
import org.apache.commons.vfs.util.RandomAccessMode;

public class RamFileObject
extends AbstractFileObject
implements FileObject {
    RamFileSystem fs;
    private RamFileData data;

    private void save() throws FileSystemException {
        this.fs.save(this);
    }

    protected RamFileObject(FileName name, RamFileSystem fs) {
        super(name, fs);
        this.fs = fs;
        this.fs.attach(this);
    }

    protected FileType doGetType() throws Exception {
        return this.data.getType();
    }

    protected String[] doListChildren() throws Exception {
        return this.fs.listChildren(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.data.getBuffer().length;
    }

    protected InputStream doGetInputStream() throws Exception {
        return new ByteArrayInputStream(this.data.getBuffer());
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (!bAppend) {
            this.data.setBuffer(new byte[0]);
        }
        return new RamFileOutputStream(this);
    }

    protected void doDelete() throws Exception {
        this.fs.delete(this);
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.data.getLastModified();
    }

    protected void doSetLastModifiedTime(long modtime) throws Exception {
        this.data.setLastModified(modtime);
    }

    protected void doCreateFolder() throws Exception {
        this.injectType(FileType.FOLDER);
        this.save();
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.fs.rename(this, (RamFileObject)newfile);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new RamFileRandomAccessContent(this, mode);
    }

    protected void doAttach() throws Exception {
        this.fs.attach(this);
    }

    public RamFileData getData() {
        return this.data;
    }

    public void setData(RamFileData data) {
        this.data = data;
    }

    protected void injectType(FileType fileType) {
        this.data.setType(fileType);
        super.injectType(fileType);
    }

    protected void endOutput() throws Exception {
        super.endOutput();
        this.save();
    }

    public int size() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    public synchronized void resize(int newSize) throws IOException {
        if (this.fs.getFileSystemOptions() != null) {
            int maxSize = RamFileSystemConfigBuilder.getInstance().getMaxSize(this.fs.getFileSystemOptions());
            if (this.fs.size() + newSize - this.size() > maxSize) {
                throw new IOException("FileSystem capacity (" + maxSize + ") exceeded.");
            }
        }
        this.data.resize(newSize);
    }
}

