/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.ClassFactory;
import java.io.File;
import java.io.IOException;

public class FilesystemCodeBaseLocator
implements ICodeBaseLocator {
    private final String pathName;

    public FilesystemCodeBaseLocator(String pathName) {
        this.pathName = pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public ICodeBaseLocator createRelativeCodeBaseLocator(String relativePath) {
        File path = new File(this.pathName);
        if (!path.isDirectory()) {
            path = path.getParentFile();
        }
        File relativeFile = new File(path, relativePath);
        return new FilesystemCodeBaseLocator(relativeFile.getPath());
    }

    public ICodeBase openCodeBase() throws IOException {
        return ClassFactory.createFilesystemCodeBase(this);
    }

    public String toString() {
        return "filesystem:" + this.pathName;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        FilesystemCodeBaseLocator other = (FilesystemCodeBaseLocator)obj;
        return this.pathName.equals(other.pathName);
    }

    public int hashCode() {
        return this.pathName.hashCode();
    }
}

