/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.perl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.epic.core.util.PerlExecutor;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.templates.ui.LinkedPositionManager;
import org.epic.perleditor.templates.ui.LinkedPositionUI;

public class ModuleCompletionHelper {
    private static ModuleCompletionHelper gInstance;
    private final String perlCode;
    private String[] moduleNames;
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    public static synchronized ModuleCompletionHelper getInstance() {
        if (gInstance == null) {
            gInstance = new ModuleCompletionHelper();
        }
        return gInstance;
    }

    private ModuleCompletionHelper() {
        StringBuffer sb = new StringBuffer();
        sb.append("use strict;\n");
        sb.append("use File::Find;\n");
        sb.append("\n");
        sb.append("my %foundmods;\n");
        sb.append("\n");
        sb.append("find ( \n");
        sb.append("  sub {\n");
        sb.append("    return if ((/^\\./) || (! -f $File::Find::name) || (! /\\.pm$/));\n");
        sb.append("\n");
        sb.append("    open(MODFILE,$File::Find::name) || return;\n");
        sb.append("    while (<MODFILE>) { \n");
        sb.append("        if (/^\\s*package\\s+(\\S+);/){\n");
        sb.append("         $foundmods{$1} = 1;\n");
        sb.append("         last; \n");
        sb.append("     } \n");
        sb.append("    }  \n");
        sb.append("    close(MODFILE);\n");
        sb.append("  }, @INC\n");
        sb.append(");\n");
        sb.append("\n");
        sb.append("map { print $_ . \"\\n\"; } sort keys %foundmods;\n");
        this.perlCode = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scanForModules(TextEditor textEditor) throws CoreException {
        if (!PerlEditorPlugin.getDefault().requirePerlInterpreter(false)) {
            return;
        }
        PerlExecutor executor = new PerlExecutor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.perleditor.templates.perl.ModuleCompletionHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            try {
                List names = executor.execute((ITextEditor)textEditor, null, this.perlCode).getStdoutLines();
                this.moduleNames = names.toArray(new String[names.size()]);
                this.initialized = true;
                Object var5_7 = null;
                executor.dispose();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                executor.dispose();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompletionProposal[] getProposals(String moduleNameFragment, int documentOffset, ITextViewer viewer) {
        if (!this.initialized) {
            return new ICompletionProposal[0];
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.perleditor.templates.perl.ModuleCompletionHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            ArrayList<ModuleProposal> al = new ArrayList<ModuleProposal>();
            int loop = 0;
            while (loop < this.moduleNames.length) {
                String moduleName = this.moduleNames[loop];
                if (moduleNameFragment == null || moduleNameFragment.equals("") || moduleName.startsWith(moduleNameFragment)) {
                    al.add(new ModuleProposal(moduleName, moduleNameFragment, documentOffset, viewer));
                }
                ++loop;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return al.toArray(new ICompletionProposal[0]);
        }
    }

    class ModuleProposal
    implements ICompletionProposal {
        private String moduleName;
        private String moduleNameFragment;
        private int documentOffset;
        private ITextViewer fViewer;

        public ModuleProposal(String moduleName, String moduleNameFragment, int documentOffset, ITextViewer viewer) {
            this.moduleName = moduleName;
            this.moduleNameFragment = moduleNameFragment;
            this.documentOffset = documentOffset;
            this.fViewer = viewer;
        }

        public void apply(IDocument document) {
            String replacementText = String.valueOf(this.moduleName) + ";";
            String moriturus = this.moduleNameFragment;
            int len = moriturus.length();
            int start = this.documentOffset - len;
            try {
                document.replace(start, len, replacementText);
                LinkedPositionManager manager = new LinkedPositionManager(document);
                LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
                editor.setFinalCaretOffset(replacementText.length() + start);
                editor.enter();
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public String getDisplayString() {
            return this.moduleName;
        }

        public Image getImage() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }
}

