/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors.perl;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PerlEditorMessages;
import org.epic.perleditor.editors.PerlPairMatcher;
import org.epic.perleditor.editors.util.PreferenceUtil;

public final class PerlAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private final PerlPairMatcher bracketMatcher = new PerlPairMatcher(PerlEditorPlugin.getDefault().getLog());

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1) {
            this.smartIndentAfterNewLine(d, c);
        } else if ("}".equals(c.text)) {
            this.smartInsertAfterBracket(d, c);
        }
    }

    private String getIndentOfLine(IDocument document, int line) throws BadLocationException {
        if (line > -1) {
            int start = document.getLineOffset(line);
            int end = start + document.getLineLength(line) - 1;
            int whiteend = this.findEndOfWhiteSpace(document, start, end);
            return document.get(start, whiteend - start);
        }
        return "";
    }

    private boolean handleNewLineAfterHashClosingBracket(IDocument document, int whiteend, StringBuffer textToInsert) throws BadLocationException {
        IRegion block;
        int docLength = document.getLength();
        if (whiteend < docLength && "}".equals(document.get(whiteend, 1)) && (block = this.bracketMatcher.match(document, whiteend + 1)) != null && this.isHash(document, block)) {
            int hashStartLine = document.getLineOfOffset(block.getOffset());
            textToInsert.append(this.getIndentOfLine(document, hashStartLine));
            return true;
        }
        return false;
    }

    private boolean handleNewLineAfterOpeningBracket(IDocument document, DocumentCommand command, int start, int line, StringBuffer textToInsert) throws BadLocationException {
        String lineText = document.get(start, document.getLineLength(line));
        int openBracketIndex = lineText.indexOf(123);
        if (openBracketIndex == -1) {
            return false;
        }
        if ("COMMENT".equals(document.getPartition(start + openBracketIndex).getType())) {
            return false;
        }
        IRegion block = this.bracketMatcher.match(document, command.offset + 1, '}');
        if (block == null) {
            return false;
        }
        if (document.getLineOfOffset(block.getOffset()) == line) {
            textToInsert.append(PreferenceUtil.getTab(0));
            return true;
        }
        return false;
    }

    private void handleNewLineWithinBlock(IDocument document, DocumentCommand command, StringBuffer textToInsert) throws BadLocationException {
        int docLength = document.getLength();
        int p = command.offset == docLength ? command.offset - 1 : command.offset;
        int line = document.getLineOfOffset(p);
        int start = document.getLineOffset(line);
        int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
        if (this.handleNewLineAfterHashClosingBracket(document, whiteend, textToInsert)) {
            return;
        }
        textToInsert.append(document.get(start, whiteend - start));
        this.handleNewLineAfterOpeningBracket(document, command, start, line, textToInsert);
    }

    private void handleNewLineBeforeClosingBracket(IDocument document, DocumentCommand command, StringBuffer textToInsert) throws BadLocationException {
        IRegion block = this.bracketMatcher.match(document, command.offset + 1);
        if (block == null) {
            return;
        }
        boolean bothBracketsWereOnSameLine = document.getLineOfOffset(block.getOffset()) == document.getLineOfOffset(command.offset);
        textToInsert.append(this.getIndentOfLine(document, document.getLineOfOffset(block.getOffset())));
        if (bothBracketsWereOnSameLine) {
            textToInsert.append(PreferenceUtil.getTab(0));
            command.shiftsCaret = false;
            command.caretOffset = command.offset + textToInsert.length();
            textToInsert.append(TextUtilities.getDefaultLineDelimiter((IDocument)document));
            textToInsert.append(this.getIndentOfLine(document, document.getLineOfOffset(block.getOffset())));
        }
        if (this.isHash(document, block)) {
            textToInsert.append(PreferenceUtil.getTab(0));
        }
    }

    private boolean isHash(IDocument document, IRegion block) throws BadLocationException {
        int offset = block.getOffset() - 1;
        while (offset >= 0) {
            ITypedRegion p = document.getPartition(offset);
            if ("OPERATOR".equals(p.getType())) {
                String op = document.get(p.getOffset(), p.getLength());
                return "=".equals(op) || "(".equals(op) || "=>".equals(op);
            }
            offset = p.getOffset() - 1;
        }
        return false;
    }

    private boolean newLineInsertedBeforeClosingBracket(IDocument document, DocumentCommand command) throws BadLocationException {
        return command.offset < document.getLength() && document.getChar(command.offset) == '}';
    }

    private void smartIndentAfterNewLine(IDocument document, DocumentCommand command) {
        int docLength = document.getLength();
        if (command.offset == -1 || docLength == 0) {
            return;
        }
        try {
            StringBuffer buf = new StringBuffer(command.text);
            if (this.newLineInsertedBeforeClosingBracket(document, command)) {
                this.handleNewLineBeforeClosingBracket(document, command, buf);
            } else {
                this.handleNewLineWithinBlock(document, command, buf);
            }
            command.text = buf.toString();
        }
        catch (BadLocationException badLocationException) {
            System.out.println(PerlEditorMessages.getString("AutoIndent.error.bad_location_1"));
        }
    }

    private void smartInsertAfterBracket(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        try {
            int p = command.offset == document.getLength() ? command.offset - 1 : command.offset;
            int line = document.getLineOfOffset(p);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            if (whiteend != command.offset) {
                return;
            }
            IRegion block = this.bracketMatcher.match(document, command.offset, '}');
            if (block == null) {
                return;
            }
            int indLine = document.getLineOfOffset(block.getOffset());
            if (indLine == line) {
                return;
            }
            StringBuffer replaceText = new StringBuffer(this.getIndentOfLine(document, indLine));
            replaceText.append(document.get(whiteend, command.offset - whiteend));
            if (this.isHash(document, block)) {
                replaceText.append(PreferenceUtil.getTab(0));
            }
            replaceText.append(command.text);
            command.length = command.offset - start;
            command.offset = start;
            command.text = replaceText.toString();
        }
        catch (BadLocationException badLocationException) {
            System.out.println(PerlEditorMessages.getString("AutoIndent.error.bad_location_2"));
        }
    }
}

