/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.sprm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.poi.hwpf.sprm.SprmIterator;
import org.apache.poi.hwpf.sprm.SprmOperation;
import org.apache.poi.hwpf.sprm.SprmUncompressor;
import org.apache.poi.hwpf.usermodel.BorderCode;
import org.apache.poi.hwpf.usermodel.DateAndTime;
import org.apache.poi.hwpf.usermodel.DropCapSpecifier;
import org.apache.poi.hwpf.usermodel.LineSpacingDescriptor;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.hwpf.usermodel.ShadingDescriptor;
import org.apache.poi.util.LittleEndian;

public class ParagraphSprmUncompressor
extends SprmUncompressor {
    public static ParagraphProperties uncompressPAP(ParagraphProperties paragraphProperties, byte[] byArray, int n) {
        ParagraphProperties paragraphProperties2 = null;
        try {
            paragraphProperties2 = (ParagraphProperties)paragraphProperties.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("There is no way this exception should happen!!");
        }
        SprmIterator sprmIterator = new SprmIterator(byArray, n);
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            if (sprmOperation.getType() != 1) continue;
            ParagraphSprmUncompressor.unCompressPAPOperation(paragraphProperties2, sprmOperation);
        }
        return paragraphProperties2;
    }

    static void unCompressPAPOperation(ParagraphProperties paragraphProperties, SprmOperation sprmOperation) {
        switch (sprmOperation.getOperation()) {
            case 0: {
                paragraphProperties.setIstd(sprmOperation.getOperand());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (paragraphProperties.getIstd() > 9 && paragraphProperties.getIstd() < 1) break;
                byte by = (byte)sprmOperation.getOperand();
                paragraphProperties.setIstd(paragraphProperties.getIstd() + by);
                paragraphProperties.setLvl((byte)(paragraphProperties.getLvl() + by));
                if ((by >> 7 & 1) == 1) {
                    paragraphProperties.setIstd(Math.max(paragraphProperties.getIstd(), 1));
                    break;
                }
                paragraphProperties.setIstd(Math.min(paragraphProperties.getIstd(), 9));
                break;
            }
            case 3: {
                paragraphProperties.setJc((byte)sprmOperation.getOperand());
                break;
            }
            case 4: {
                paragraphProperties.setFSideBySide((byte)sprmOperation.getOperand());
                break;
            }
            case 5: {
                paragraphProperties.setFKeep((byte)sprmOperation.getOperand());
                break;
            }
            case 6: {
                paragraphProperties.setFKeepFollow((byte)sprmOperation.getOperand());
                break;
            }
            case 7: {
                paragraphProperties.setFPageBreakBefore((byte)sprmOperation.getOperand());
                break;
            }
            case 8: {
                paragraphProperties.setBrcl((byte)sprmOperation.getOperand());
                break;
            }
            case 9: {
                paragraphProperties.setBrcp((byte)sprmOperation.getOperand());
                break;
            }
            case 10: {
                paragraphProperties.setIlvl((byte)sprmOperation.getOperand());
                break;
            }
            case 11: {
                paragraphProperties.setIlfo(sprmOperation.getOperand());
                break;
            }
            case 12: {
                paragraphProperties.setFNoLnn((byte)sprmOperation.getOperand());
                break;
            }
            case 13: {
                ParagraphSprmUncompressor.handleTabs(paragraphProperties, sprmOperation);
                break;
            }
            case 14: {
                paragraphProperties.setDxaRight(sprmOperation.getOperand());
                break;
            }
            case 15: {
                paragraphProperties.setDxaLeft(sprmOperation.getOperand());
                break;
            }
            case 16: {
                paragraphProperties.setDxaLeft(paragraphProperties.getDxaLeft() + sprmOperation.getOperand());
                paragraphProperties.setDxaLeft(Math.max(0, paragraphProperties.getDxaLeft()));
                break;
            }
            case 17: {
                paragraphProperties.setDxaLeft1(sprmOperation.getOperand());
                break;
            }
            case 18: {
                paragraphProperties.setLspd(new LineSpacingDescriptor(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 19: {
                paragraphProperties.setDyaBefore(sprmOperation.getOperand());
                break;
            }
            case 20: {
                paragraphProperties.setDyaAfter(sprmOperation.getOperand());
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                paragraphProperties.setFInTable((byte)sprmOperation.getOperand());
                break;
            }
            case 23: {
                paragraphProperties.setFTtp((byte)sprmOperation.getOperand());
                break;
            }
            case 24: {
                paragraphProperties.setDxaAbs(sprmOperation.getOperand());
                break;
            }
            case 25: {
                paragraphProperties.setDyaAbs(sprmOperation.getOperand());
                break;
            }
            case 26: {
                paragraphProperties.setDxaWidth(sprmOperation.getOperand());
                break;
            }
            case 27: {
                byte by = (byte)sprmOperation.getOperand();
                byte by2 = (byte)((by & 0xC) >> 2);
                byte by3 = (byte)(by & 3);
                if (by2 != 3) {
                    paragraphProperties.setPcVert(by2);
                }
                if (by3 == 3) break;
                paragraphProperties.setPcHorz(by3);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                paragraphProperties.setDxaFromText(sprmOperation.getOperand());
                break;
            }
            case 35: {
                paragraphProperties.setWr((byte)sprmOperation.getOperand());
                break;
            }
            case 36: {
                paragraphProperties.setBrcTop(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 37: {
                paragraphProperties.setBrcLeft(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 38: {
                paragraphProperties.setBrcBottom(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 39: {
                paragraphProperties.setBrcRight(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 40: {
                paragraphProperties.setBrcBetween(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 41: {
                paragraphProperties.setBrcBar(new BorderCode(sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset()));
                break;
            }
            case 42: {
                paragraphProperties.setFNoAutoHyph((byte)sprmOperation.getOperand());
                break;
            }
            case 43: {
                paragraphProperties.setDyaHeight(sprmOperation.getOperand());
                break;
            }
            case 44: {
                paragraphProperties.setDcs(new DropCapSpecifier((short)sprmOperation.getOperand()));
                break;
            }
            case 45: {
                paragraphProperties.setShd(new ShadingDescriptor((short)sprmOperation.getOperand()));
                break;
            }
            case 46: {
                paragraphProperties.setDyaFromText(sprmOperation.getOperand());
                break;
            }
            case 47: {
                paragraphProperties.setDxaFromText(sprmOperation.getOperand());
                break;
            }
            case 48: {
                paragraphProperties.setFLocked((byte)sprmOperation.getOperand());
                break;
            }
            case 49: {
                paragraphProperties.setFWidowControl((byte)sprmOperation.getOperand());
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                paragraphProperties.setFKinsoku((byte)sprmOperation.getOperand());
                break;
            }
            case 52: {
                paragraphProperties.setFWordWrap((byte)sprmOperation.getOperand());
                break;
            }
            case 53: {
                paragraphProperties.setFOverflowPunct((byte)sprmOperation.getOperand());
                break;
            }
            case 54: {
                paragraphProperties.setFTopLinePunct((byte)sprmOperation.getOperand());
                break;
            }
            case 55: {
                paragraphProperties.setFAutoSpaceDE((byte)sprmOperation.getOperand());
                break;
            }
            case 56: {
                paragraphProperties.setFAutoSpaceDN((byte)sprmOperation.getOperand());
                break;
            }
            case 57: {
                paragraphProperties.setWAlignFont(sprmOperation.getOperand());
                break;
            }
            case 58: {
                paragraphProperties.setFontAlign((short)sprmOperation.getOperand());
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                byte[] byArray = new byte[sprmOperation.size() - 3];
                System.arraycopy(byArray, 0, sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset(), byArray.length);
                paragraphProperties.setAnld(byArray);
                break;
            }
            case 63: {
                try {
                    byte[] byArray = sprmOperation.getGrpprl();
                    int n = sprmOperation.getGrpprlOffset();
                    paragraphProperties.setFPropRMark(byArray[n]);
                    paragraphProperties.setIbstPropRMark(LittleEndian.getShort(byArray, n + 1));
                    paragraphProperties.setDttmPropRMark(new DateAndTime(byArray, n + 3));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 64: {
                if (paragraphProperties.getIstd() < 1 || paragraphProperties.getIstd() > 9) break;
                paragraphProperties.setIlvl((byte)sprmOperation.getOperand());
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                paragraphProperties.setFNumRMIns((byte)sprmOperation.getOperand());
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (sprmOperation.getSizeCode() != 6) break;
                byte[] byArray = new byte[sprmOperation.size() - 3];
                System.arraycopy(byArray, 0, sprmOperation.getGrpprl(), sprmOperation.getGrpprlOffset(), byArray.length);
                paragraphProperties.setNumrm(byArray);
                break;
            }
            case 71: {
                paragraphProperties.setFUsePgsuSettings((byte)sprmOperation.getOperand());
                break;
            }
            case 72: {
                paragraphProperties.setFAdjustRight((byte)sprmOperation.getOperand());
                break;
            }
            case 73: {
                paragraphProperties.setTableLevel((byte)sprmOperation.getOperand());
                break;
            }
            case 75: {
                paragraphProperties.setEmbeddedCellMark((byte)sprmOperation.getOperand());
                break;
            }
            case 76: {
                paragraphProperties.setFTtpEmbedded((byte)sprmOperation.getOperand());
                break;
            }
        }
    }

    private static void handleTabs(ParagraphProperties paragraphProperties, SprmOperation sprmOperation) {
        Object object;
        int n;
        byte[] byArray = sprmOperation.getGrpprl();
        int n2 = sprmOperation.getGrpprlOffset();
        byte by = byArray[n2++];
        int[] nArray = paragraphProperties.getRgdxaTab();
        byte[] byArray2 = paragraphProperties.getRgtbd();
        HashMap<Object, Byte> hashMap = new HashMap<Object, Byte>();
        for (n = 0; n < nArray.length; ++n) {
            hashMap.put(new Integer(nArray[n]), new Byte(byArray2[n]));
        }
        for (n = 0; n < by; ++n) {
            hashMap.remove(new Integer(LittleEndian.getInt(byArray, n2)));
            n2 += 4;
        }
        n = byArray[n2++];
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            object = new Integer(LittleEndian.getShort(byArray, n2));
            Byte by2 = new Byte(byArray[n3 + (2 * n + i)]);
            hashMap.put(object, by2);
            n2 += 2;
        }
        nArray = new int[hashMap.size()];
        byArray2 = new byte[nArray.length];
        ArrayList arrayList = new ArrayList();
        object = hashMap.keySet().iterator();
        while (object.hasNext()) {
            arrayList.add(object.next());
        }
        Collections.sort(arrayList);
        for (int i = 0; i < nArray.length; ++i) {
            Integer n4 = (Integer)arrayList.get(i);
            nArray[i] = n4;
            byArray2[i] = (Byte)hashMap.get(n4);
        }
        paragraphProperties.setRgdxaTab(nArray);
        paragraphProperties.setRgtbd(byArray2);
    }
}

