/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.LittleEndian;

public abstract class FormattedDiskPage {
    protected byte[] _fkp;
    protected int _crun;
    protected int _offset;

    public FormattedDiskPage() {
    }

    public FormattedDiskPage(byte[] byArray, int n) {
        this._crun = LittleEndian.getUnsignedByte(byArray, n + 511);
        this._fkp = byArray;
        this._offset = n;
    }

    protected int getStart(int n) {
        return LittleEndian.getInt(this._fkp, this._offset + n * 4);
    }

    protected int getEnd(int n) {
        return LittleEndian.getInt(this._fkp, this._offset + (n + 1) * 4);
    }

    public int size() {
        return this._crun;
    }

    protected abstract byte[] getGrpprl(int var1);
}

