/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.h2.message.TraceSystem;
import org.h2.web.WebServer;
import org.h2.web.WebServerSession;

public class AppSession
extends WebServerSession {
    private static final int MAX_HISTORY = 1000;
    private ArrayList commandHistory = new ArrayList();
    private Connection conn;
    DatabaseMetaData meta;
    Statement executingStatement;
    ResultSet result;

    AppSession(WebServer server) {
        super(server);
    }

    String getCommand(int id) {
        return (String)this.commandHistory.get(id);
    }

    void addCommand(String sql) {
        int idx;
        if (sql == null) {
            return;
        }
        if ((sql = sql.trim()).length() == 0) {
            return;
        }
        if (this.commandHistory.size() > 1000) {
            this.commandHistory.remove(0);
        }
        if ((idx = this.commandHistory.indexOf(sql)) >= 0) {
            this.commandHistory.remove(idx);
        }
        this.commandHistory.add(sql);
    }

    ArrayList getCommands() {
        return this.commandHistory;
    }

    public HashMap getInfo() {
        HashMap m = super.getInfo();
        try {
            m.put("url", this.conn == null ? "not connected" : this.conn.getMetaData().getURL());
            m.put("user", this.conn == null ? "-" : this.conn.getMetaData().getUserName());
            m.put("lastQuery", this.commandHistory.size() == 0 ? "" : this.commandHistory.get(0));
            m.put("executing", this.executingStatement == null ? "no" : "yes");
        }
        catch (SQLException e) {
            TraceSystem.traceThrowable(e);
        }
        return m;
    }

    void setConnection(Connection conn) throws SQLException {
        this.conn = conn;
        this.meta = conn == null ? null : conn.getMetaData();
    }

    DatabaseMetaData getMetaData() {
        return this.meta;
    }

    boolean isH2() throws SQLException {
        return this.meta.getURL().startsWith("jdbc:h2:");
    }

    boolean isOracle() throws SQLException {
        return this.meta.getURL().startsWith("jdbc:oracle:");
    }

    public boolean isHSQLDB() throws SQLException {
        return this.meta.getURL().startsWith("jdbc:hsqldb:");
    }

    public boolean isPostgreSQL() throws SQLException {
        return this.meta.getURL().startsWith("jdbc:postgresql:");
    }

    Connection getConnection() {
        return this.conn;
    }
}

