/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.doc;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.h2.test.bnf.RuleParser;

public class MergeDocs {
    String baseDir = "docs/html";

    public static void main(String[] args) throws Exception {
        new MergeDocs().run(args);
    }

    private void run(String[] args) throws Exception {
        String[] pages = new String[]{"quickstartText.html", "installation.html", "tutorial.html", "features.html", "performance.html", "advanced.html", "grammar.html", "functions.html", "datatypes.html", "build.html", "history.html", "faq.html", "license.html"};
        String finalText = "";
        for (int i = 0; i < pages.length; ++i) {
            String text = this.getContent(pages[i]);
            for (int j = 0; j < pages.length; ++j) {
                text = RuleParser.replaceAll(text, pages[j] + "#", "#");
            }
            text = this.removeHeaderFooter(text);
            finalText = finalText + text;
        }
        File output = new File(this.baseDir, "onePage.html");
        PrintWriter writer = new PrintWriter(new FileWriter(output));
        writer.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"><title>");
        writer.println("H2 Documentation");
        writer.println("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"stylesheetPdf.css\"></head><body>");
        writer.println(finalText);
        writer.println("</body></html>");
        writer.close();
    }

    private String removeHeaderFooter(String text) {
        String start = "<div class=\"contentDiv\"";
        String end = "</div></td></tr></table></body></html>";
        int idx = text.indexOf(end);
        text = text.substring(0, idx);
        idx = text.indexOf(start);
        idx = text.indexOf(62, idx);
        text = text.substring(idx + 1);
        return text;
    }

    String getContent(String fileName) throws Exception {
        int len;
        int length;
        File file = new File(this.baseDir, fileName);
        char[] data = new char[length];
        FileReader reader = new FileReader(file);
        int off = 0;
        for (length = (int)file.length(); length > 0; length -= len) {
            len = reader.read(data, off, length);
            off += len;
        }
        reader.close();
        String s = new String(data);
        return s;
    }
}

