/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.TraceSystem;
import org.h2.server.OdbcServer;
import org.h2.server.Service;
import org.h2.server.TcpServer;
import org.h2.util.StartBrowser;
import org.h2.web.WebServer;

public class Server
implements Runnable {
    private String[] args;
    private Service service;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [options]");
        System.out.println("By default, -tcp, -web, -browser and -odbc are started");
        System.out.println("-tcp (start the TCP Server)");
        System.out.println("-tcpPort <port>");
        System.out.println("-tcpSSL [true|false]");
        System.out.println("-tcpAllowOthers [true|false]");
        System.out.println("-tcpPassword {password} (the password for shutting down a TCP Server)");
        System.out.println("-tcpShutdown {url} (shutdown the TCP Server, URL example: tcp://localhost:9094)");
        System.out.println("-tcpShutdownForce [true|false] (don't wait for other connections to close)");
        System.out.println("-web (start the Web Server)");
        System.out.println("-webPort <port>");
        System.out.println("-webSSL [true|false}");
        System.out.println("-webAllowOthers [true|false}");
        System.out.println("-browser (start a browser)");
        System.out.println("-odbc (start the ODBC Server)");
        System.out.println("-odbcPort <port>");
        System.out.println("-odbcAllowOthers [true|false]");
        System.out.println("-log [true|false]");
        System.out.println("-baseDir <directory>");
        System.out.println("-ifExists [true|false] (only existing databases may be opened)");
    }

    private Server() {
    }

    public static void main(String[] args) throws Exception {
        new Server().run(args);
    }

    private void run(String[] args) throws Exception {
        boolean tcpStart = false;
        boolean odbcStart = false;
        boolean webStart = false;
        boolean browserStart = false;
        boolean tcpShutdown = false;
        boolean tcpShutdownForce = false;
        String tcpPassword = "";
        String tcpShutdownServer = "";
        boolean startDefaultServers = true;
        if (args.length > 0) {
            for (int i = 0; args != null && i < args.length; ++i) {
                String a = args[i];
                if (a.equals("-?") || a.equals("-help")) {
                    this.showUsage();
                    return;
                }
                if (a.equals("-web")) {
                    startDefaultServers = false;
                    webStart = true;
                    continue;
                }
                if (a.equals("-odbc")) {
                    startDefaultServers = false;
                    odbcStart = true;
                    continue;
                }
                if (a.equals("-tcp")) {
                    startDefaultServers = false;
                    tcpStart = true;
                    continue;
                }
                if (a.equals("-tcpShutdown")) {
                    startDefaultServers = false;
                    tcpShutdown = true;
                    tcpShutdownServer = args[++i];
                    continue;
                }
                if (a.equals("-tcpPassword")) {
                    tcpPassword = args[++i];
                    continue;
                }
                if (a.equals("-tcpShutdownForce")) {
                    tcpShutdownForce = true;
                    continue;
                }
                if (!a.equals("-browser")) continue;
                startDefaultServers = false;
                browserStart = true;
            }
        }
        if (startDefaultServers) {
            tcpStart = true;
            odbcStart = true;
            webStart = true;
            browserStart = true;
        }
        if (tcpShutdown) {
            System.out.println("Shutting down TCP Server at " + tcpShutdownServer);
            Server.shutdownTcpServer(tcpShutdownServer, tcpPassword, tcpShutdownForce);
        }
        if (tcpStart) {
            Server tcp = Server.startTcpServer(args);
            System.out.println(tcp.getStatus());
        }
        if (odbcStart) {
            Server odbc = Server.startOdbcServer(args);
            System.out.println(odbc.getStatus());
        }
        if (webStart) {
            Server web = Server.startWebServer(args);
            System.out.println(web.getStatus());
            if (browserStart) {
                StartBrowser.openURL(web.getURL());
            }
        }
    }

    public static void shutdownTcpServer(String url, String password, boolean force) throws ClassNotFoundException, SQLException {
        int port = 9092;
        int idx = url.indexOf(58, "jdbc:h2:".length());
        if (idx >= 0) {
            String p = url.substring(idx + 1);
            if ((idx = p.indexOf(47)) >= 0) {
                p = p.substring(0, idx);
            }
            port = Integer.parseInt(p);
        }
        String db = TcpServer.getManagementDbName(port);
        Class.forName("org.h2.Driver");
        for (int i = 0; i < 2; ++i) {
            try {
                Connection conn = DriverManager.getConnection("jdbc:h2:" + url + "/" + db, "sa", password);
                PreparedStatement prep = conn.prepareStatement("CALL STOP_SERVER(?, ?, ?)");
                prep.setInt(1, port);
                prep.setString(2, password);
                prep.setInt(3, force ? 1 : 0);
                prep.execute();
                conn.close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private String getStatus() {
        StringBuffer buff = new StringBuffer();
        if (this.isRunning()) {
            buff.append(this.service.getType());
            buff.append(" server running on ");
            buff.append(this.service.getURL());
            buff.append(" (");
            if (this.service.getAllowOthers()) {
                buff.append("others can connect");
            } else {
                buff.append("only local connections");
            }
            buff.append(")");
        } else {
            buff.append("Port is in use, maybe another Web server already running on ");
            buff.append(this.service.getURL());
        }
        return buff.toString();
    }

    public static Server startWebServer(String[] args) {
        return Server.start("H2 Console Server", new WebServer(), args);
    }

    public static Server startOdbcServer(String[] args) {
        return Server.start("H2 ODBC Server", new OdbcServer(), args);
    }

    public static Server startTcpServer(String[] args) {
        return Server.start("H2 TCP Server", new TcpServer(), args);
    }

    private static Server start(String name, Service service, String[] args) {
        Server server = new Server(service, args);
        Thread t = new Thread(server);
        t.setName(name);
        t.start();
        for (int i = 0; i < 100; ++i) {
            Thread.yield();
            if (server.isRunning()) break;
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return server;
    }

    public boolean isRunning() {
        return this.service.isRunning();
    }

    public void stop() {
        this.service.stop();
    }

    public String getURL() {
        return this.service.getURL();
    }

    private Server(Service service, String[] args) {
        this.service = service;
        this.args = args;
    }

    public void run() {
        try {
            this.service.init(this.args);
            this.service.start();
            this.service.listen();
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
        }
    }
}

