/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RunScript {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <file>]");
    }

    public static void main(String[] args) throws Exception {
        new RunScript().run(args);
    }

    private void run(String[] args) throws Exception {
        String url = null;
        String user = null;
        String password = "";
        String script = "backup.sql";
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || password == null || script == null) {
            this.showUsage();
            return;
        }
        RunScript.execute(url, user, password, script, null);
    }

    public static ResultSet execute(Connection conn, Reader reader) throws SQLException, IOException {
        String line;
        Statement stat = conn.createStatement();
        LineNumberReader lineReader = new LineNumberReader(reader);
        String lastLine = null;
        ResultSet rs = null;
        while ((line = lineReader.readLine()) != null) {
            line = line.trim();
            if (lastLine != null) {
                line = lastLine + "\n" + line;
            }
            if (line.endsWith(";")) {
                boolean resultset = stat.execute(line = line.substring(0, line.length() - 1));
                if (resultset) {
                    rs = stat.getResultSet();
                }
                lastLine = null;
                continue;
            }
            lastLine = line;
        }
        lineReader.close();
        return rs;
    }

    public static void execute(String url, String user, String password, String fileName, String charsetName) throws Exception {
        Class.forName("org.h2.Driver");
        if (charsetName == null) {
            charsetName = "UTF8";
        }
        Connection conn = DriverManager.getConnection(url, user, password);
        FileInputStream in = new FileInputStream(fileName);
        BufferedInputStream bin = new BufferedInputStream(in, 4096);
        InputStreamReader inReader = new InputStreamReader((InputStream)bin, charsetName);
        RunScript.execute(conn, inReader);
        ((InputStream)in).close();
        conn.close();
    }
}

