/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.tools.SimpleResultSet;
import org.h2.tools.SimpleRowSource;
import org.h2.util.StringUtils;

public class Csv
implements SimpleRowSource {
    private String charset = StringUtils.getDefaultCharset();
    private int bufferSize = 8192;
    private String[] columnNames;
    private char fieldSeparatorRead = (char)44;
    private char commentLineStart = (char)35;
    private String fieldSeparatorWrite = ",";
    private char fieldDelimiter = (char)34;
    private char escapeCharacter = (char)34;
    private String fileName;
    private FileInputStream in;
    private Reader reader;
    private FileOutputStream out;
    private PrintWriter writer;
    private int back;
    private boolean endOfLine;
    private boolean endOfFile;

    public static void write(String fileName, ResultSet rs, String charset) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        Csv csv = new Csv(fileName, charset);
        try {
            int i;
            csv.initWrite();
            int columnCount = meta.getColumnCount();
            String[] row = new String[columnCount];
            for (i = 0; i < columnCount; ++i) {
                row[i] = meta.getColumnLabel(i + 1);
            }
            csv.writeRow(row);
            while (rs.next()) {
                for (i = 0; i < columnCount; ++i) {
                    row[i] = rs.getString(i + 1);
                }
                csv.writeRow(row);
            }
            csv.close();
        }
        catch (IOException e) {
            throw csv.convertException("IOException writing file " + fileName, e);
        }
        rs.close();
    }

    public static void write(Connection conn, String fileName, String sql, String charset) throws SQLException {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery(sql);
        Csv.write(fileName, rs, charset);
        stat.close();
    }

    public static ResultSet read(String fileName, String[] columnNames, String charset) throws SQLException {
        Csv csv = new Csv(fileName, charset);
        try {
            csv.columnNames = columnNames;
            csv.initRead(fileName);
            SimpleResultSet result = new SimpleResultSet(csv);
            columnNames = csv.columnNames;
            columnNames = Csv.normalizeColumnNames(columnNames);
            for (int i = 0; i < columnNames.length; ++i) {
                result.addColumn(columnNames[i], 12, 255, 0);
            }
            return result;
        }
        catch (IOException e) {
            throw csv.convertException("IOException reading file " + fileName, e);
        }
    }

    private static String[] normalizeColumnNames(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            String x = columnNames[i];
            if (x == null || x.length() == 0) {
                x = "C" + (i + 1);
            }
            for (int j = 0; j < i; ++j) {
                String y = columnNames[j];
                if (!x.equals(y)) continue;
                x = x + "1";
                j = -1;
            }
            columnNames[i] = x;
        }
        return columnNames;
    }

    private Csv(String fileName, String charset) {
        this.fileName = fileName;
        if (charset != null) {
            this.charset = charset;
        }
    }

    private void initWrite() throws IOException {
        try {
            this.out = new FileOutputStream(this.fileName);
            BufferedOutputStream o = new BufferedOutputStream(this.out, this.bufferSize);
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)o, this.charset));
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        if (this.columnNames != null) {
            this.writeHeader();
        }
    }

    private void writeHeader() {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (i > 0) {
                this.writer.print(this.fieldSeparatorRead);
            }
            this.writer.print(this.columnNames[i]);
        }
        this.writer.println();
    }

    private void writeRow(String[] values) {
        for (int i = 0; i < values.length; ++i) {
            String s;
            if (i > 0 && this.fieldSeparatorWrite != null) {
                this.writer.print(this.fieldSeparatorWrite);
            }
            if ((s = values[i]) == null) continue;
            if (this.escapeCharacter != '\u0000') {
                if (this.fieldDelimiter != '\u0000') {
                    this.writer.print(this.fieldDelimiter);
                }
                this.writer.print(this.escape(s));
                if (this.fieldDelimiter == '\u0000') continue;
                this.writer.print(this.fieldDelimiter);
                continue;
            }
            this.writer.print(s);
        }
        this.writer.println();
    }

    private String escape(String data) {
        if (data.indexOf(this.fieldDelimiter) < 0 && (this.escapeCharacter == this.fieldDelimiter || data.indexOf(this.escapeCharacter) < 0)) {
            return data;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == this.fieldDelimiter || ch == this.escapeCharacter) {
                buff.append(this.escapeCharacter);
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    private void initRead(String fileName) throws IOException {
        try {
            this.in = new FileInputStream(fileName);
            BufferedInputStream i = new BufferedInputStream(this.in, this.bufferSize);
            this.reader = new InputStreamReader((InputStream)i, this.charset);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        if (this.columnNames == null) {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (true) {
                String v;
                if ((v = this.readValue()) == null) {
                    if (this.endOfLine && (i > 0 || this.endOfFile)) break;
                    v = "COLUMN" + i;
                }
                list.add(v);
                ++i;
            }
            this.columnNames = new String[list.size()];
            list.toArray(this.columnNames);
        }
    }

    private void pushBack(int ch) {
        this.back = ch;
    }

    private int readChar() throws IOException {
        int ch = this.back;
        if (ch != -1) {
            this.back = -1;
            return ch;
        }
        ch = this.reader.read();
        if (ch < 0) {
            this.endOfFile = true;
            this.close();
        }
        return ch;
    }

    private String readValue() throws IOException {
        this.endOfLine = false;
        String value = null;
        while (true) {
            StringBuffer buff;
            int ch;
            if ((ch = this.readChar()) < 0 || ch == 13 || ch == 10) {
                this.endOfLine = true;
                break;
            }
            if (ch <= 32) continue;
            if (ch == this.fieldSeparatorRead) break;
            if (ch == this.commentLineStart) {
                while ((ch = this.readChar()) >= 0 && ch != 13 && ch != 10) {
                }
                this.endOfLine = true;
                break;
            }
            if (ch == this.fieldDelimiter) {
                buff = new StringBuffer();
                boolean containsEscape = false;
                while (true) {
                    if ((ch = this.readChar()) < 0) {
                        return buff.toString();
                    }
                    if (ch == this.fieldDelimiter) {
                        ch = this.readChar();
                        if (ch == this.fieldDelimiter) {
                            buff.append((char)ch);
                            continue;
                        }
                        this.pushBack(ch);
                        break;
                    }
                    if (ch == this.escapeCharacter) {
                        buff.append((char)ch);
                        ch = this.readChar();
                        if (ch < 0) break;
                        containsEscape = true;
                        buff.append((char)ch);
                        continue;
                    }
                    buff.append((char)ch);
                }
                value = buff.toString();
                if (!containsEscape) continue;
                value = this.unEscape(value);
                continue;
            }
            buff = new StringBuffer();
            buff.append((char)ch);
            while ((ch = this.readChar()) != this.fieldSeparatorRead) {
                if (ch == 13 || ch == 10) {
                    this.pushBack(ch);
                    this.endOfLine = true;
                    break;
                }
                if (ch < 0) break;
                buff.append((char)ch);
            }
            value = buff.toString().trim();
        }
        return value;
    }

    private String unEscape(String s) {
        int idx;
        StringBuffer buff = new StringBuffer();
        int start = 0;
        while ((idx = s.indexOf(this.escapeCharacter, start)) >= 0) {
            buff.append(s.toCharArray(), start, idx);
            start = idx + 1;
        }
        buff.append(s.substring(start));
        return buff.toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object[] readRow() throws SQLException {
        if (this.in == null) {
            return null;
        }
        row = new String[this.columnNames.length];
        try {
            i = 0;
            while (true) {
                if ((v = this.readValue()) != null) ** GOTO lbl-1000
                if (this.endOfFile && i == 0) {
                    return null;
                }
                if (this.endOfLine) {
                    if (i != 0) break;
                    --i;
                } else if (i < row.length) {
                    row[i] = v;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw this.convertException("IOException reading from " + this.fileName, e);
        }
        return row;
    }

    private SQLException convertException(String message, Exception e) {
        SQLException s = new SQLException(message, "CSV");
        s.initCause(e);
        return s;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
    }
}

