/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;

public class TestThreads
extends TestBase
implements Runnable {
    private int maxId = 1;
    private volatile boolean stop;
    private TestThreads master;
    private int type;
    private String table;
    private Random random = new Random();
    private static final int INSERT = 0;
    private static final int UPDATE = 1;
    private static final int DELETE = 2;
    private static final int SELECT_ONE = 3;
    private static final int SELECT_ALL = 4;
    private static final int CHECKPOINT = 5;
    private static final int RECONNECT = 6;
    private static final int OP_TYPES = 7;

    public TestThreads() {
    }

    public void test() throws Exception {
        int i;
        this.deleteDb("threads");
        Connection conn = this.getConnection("threads;MAX_LOG_SIZE=1");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST_A(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE TABLE TEST_B(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("CREATE TABLE TEST_C(ID INT PRIMARY KEY, NAME VARCHAR)");
        int len = 1000;
        this.insertRows(conn, "TEST_A", len);
        this.insertRows(conn, "TEST_B", len);
        this.insertRows(conn, "TEST_C", len);
        this.maxId = len;
        int threadCount = 4;
        Thread[] threads = new Thread[threadCount];
        for (i = 0; i < threadCount; ++i) {
            String table = this.random.nextBoolean() ? null : this.getRandomTable();
            int op = this.random.nextInt(7);
            op = i % 2 == 1 ? 6 : 5;
            threads[i] = new Thread(new TestThreads(this, op, table));
        }
        for (i = 0; i < threadCount; ++i) {
            threads[i].start();
        }
        Thread.sleep(10000L);
        this.stop = true;
        for (i = 0; i < threadCount; ++i) {
            threads[i].join();
        }
        conn.close();
        conn = this.getConnection("threads");
        this.checkTable(conn, "TEST_A");
        this.checkTable(conn, "TEST_B");
        this.checkTable(conn, "TEST_C");
        conn.close();
    }

    private void insertRows(Connection conn, String tableName, int len) throws Exception {
        PreparedStatement prep = conn.prepareStatement("INSERT INTO " + tableName + " VALUES(?, 'Hi')");
        for (int i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.execute();
        }
    }

    private void checkTable(Connection conn, String tableName) throws Exception {
        Statement stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM " + tableName + " ORDER BY ID");
        while (rs.next()) {
            int id = rs.getInt(1);
            String name = rs.getString(2);
            System.out.println("id=" + id + " name=" + name);
        }
    }

    private int getMaxId() {
        return this.maxId;
    }

    private synchronized int incrementMaxId() {
        return this.maxId++;
    }

    TestThreads(TestThreads master, int type, String table) {
        this.master = master;
        this.type = type;
        this.table = table;
    }

    private String getRandomTable() {
        return "TEST_" + (char)(65 + this.random.nextInt(3));
    }

    public void run() {
        try {
            String t = this.table == null ? this.getRandomTable() : this.table;
            Connection conn = this.master.getConnection("threads");
            Statement stat = conn.createStatement();
            int max = this.master.getMaxId();
            int rid = this.random.nextInt(max);
            int i = 0;
            while (!this.master.stop) {
                switch (this.type) {
                    case 0: {
                        max = this.master.incrementMaxId();
                        stat.execute("INSERT INTO " + t + "(ID, NAME) VALUES(" + max + ", 'Hello')");
                        break;
                    }
                    case 1: {
                        stat.execute("UPDATE " + t + " SET NAME='World " + rid + "' WHERE ID=" + rid);
                        break;
                    }
                    case 2: {
                        stat.execute("DELETE FROM " + t + " WHERE ID=" + rid);
                        break;
                    }
                    case 4: {
                        ResultSet rs = stat.executeQuery("SELECT * FROM " + t + " ORDER BY ID");
                        while (rs.next()) {
                        }
                        break;
                    }
                    case 3: {
                        ResultSet rs = stat.executeQuery("SELECT * FROM " + t + " WHERE ID=" + rid);
                        while (rs.next()) {
                        }
                        break;
                    }
                    case 5: {
                        stat.execute("CHECKPOINT");
                        break;
                    }
                    case 6: {
                        conn.close();
                        conn = this.master.getConnection("threads");
                    }
                }
                ++i;
            }
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

