/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestTempTables
extends TestBase {
    public void test() throws Exception {
        this.deleteDb("tempTables");
        Connection c1 = this.getConnection("tempTables");
        Connection c2 = this.getConnection("tempTables");
        Statement s1 = c1.createStatement();
        Statement s2 = c2.createStatement();
        s1.execute("CREATE LOCAL TEMPORARY TABLE LT(A INT)");
        s1.execute("CREATE GLOBAL TEMPORARY TABLE GT1(ID INT)");
        s2.execute("CREATE GLOBAL TEMPORARY TABLE GT2(ID INT)");
        s2.execute("CREATE LOCAL TEMPORARY TABLE LT(B INT)");
        s2.execute("SELECT B FROM LT");
        s1.execute("SELECT A FROM LT");
        s1.execute("SELECT * FROM GT1");
        s2.execute("SELECT * FROM GT1");
        s1.execute("SELECT * FROM GT2");
        s2.execute("SELECT * FROM GT2");
        s2.execute("DROP TABLE GT1");
        s2.execute("DROP TABLE GT2");
        s2.execute("DROP TABLE LT");
        s1.execute("DROP TABLE LT");
        c1.setAutoCommit(false);
        s1.execute("create local temporary table testtemp(id int) on commit delete rows");
        s1.execute("insert into testtemp values(1)");
        ResultSet rs = s1.executeQuery("select * from testtemp");
        this.checkResultRowCount(rs, 1);
        c1.commit();
        rs = s1.executeQuery("select * from testtemp");
        this.checkResultRowCount(rs, 0);
        s1.execute("drop table testtemp");
        s1.execute("create local temporary table testtemp(id int) on commit drop");
        s1.execute("insert into testtemp values(1)");
        rs = s1.executeQuery("select * from testtemp");
        this.checkResultRowCount(rs, 1);
        c1.commit();
        try {
            rs = s1.executeQuery("select * from testtemp");
            this.error("testtemp should have been dropped automatically");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        c1.close();
        c2.close();
    }
}

