/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestRunscript
extends TestBase {
    public void test() throws Exception {
        this.test(false);
        this.test(true);
    }

    private void test(boolean password) throws Exception {
        this.deleteDb("runscript");
        Connection conn1 = this.getConnection("runscript");
        Statement stat1 = conn1.createStatement();
        stat1.execute("create table test (id identity, name varchar(12))");
        stat1.execute("insert into test (name) values ('first'), ('second')");
        String sql = "script to 'backup.2.sql'";
        if (password) {
            sql = sql + "CIPHER AES PASSWORD 't1e2s3t4'";
        }
        stat1.execute(sql);
        this.deleteDb("runscriptRestore");
        Connection conn2 = this.getConnection("runscriptRestore");
        Statement stat2 = conn2.createStatement();
        sql = "runscript from 'backup.2.sql'";
        if (password) {
            sql = sql + " CIPHER AES PASSWORD 'wrongpassword'";
        }
        if (password) {
            try {
                stat2.execute(sql);
                this.error("should fail");
            }
            catch (SQLException e) {
                this.checkNotGeneralException(e);
            }
        }
        sql = "runscript from 'backup.2.sql'";
        if (password) {
            sql = sql + " CIPHER AES PASSWORD 't1e2s3t4'";
        }
        stat2.execute(sql);
        this.compareDatabases(stat1, stat2);
        conn1.close();
        conn2.close();
    }

    private void compareDatabases(Statement stat1, Statement stat2) throws Exception {
        ResultSet rs1 = stat1.executeQuery("SCRIPT NOPASSWORDS");
        ResultSet rs2 = stat2.executeQuery("SCRIPT NOPASSWORDS");
        while (rs1.next()) {
            String a = rs1.getString(1);
            this.check(rs2.next());
            String b = rs2.getString(1);
            this.check(a, b);
        }
        this.checkFalse(rs2.next());
    }
}

