/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.TestBase;
import org.h2.tools.FileBase;

public class TestReadOnly
extends TestBase {
    public void test() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("readonly");
        Connection conn = this.getConnection("readonly");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello')");
        stat.execute("INSERT INTO TEST VALUES(2, 'World')");
        conn.close();
        this.setReadOnly();
        conn = this.getConnection("readonly");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        try {
            stat.execute("DELETE FROM TEST");
            this.error("read only delete");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
        conn = this.getConnection("readonly;DB_CLOSE_DELAY=1");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        try {
            stat.execute("DELETE FROM TEST");
            this.error("read only delete");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
    }

    private void setReadOnly() throws SQLException {
        ArrayList list = FileBase.getDatabaseFiles(TestBase.BASE_DIR, "readonly", true);
        for (int i = 0; i < list.size(); ++i) {
            String fileName = (String)list.get(i);
            File file = new File(fileName);
            file.setReadOnly();
        }
    }
}

