/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;

public class TestMultiConn
extends TestBase
implements DatabaseEventListener {
    private static int wait;

    public void test() throws Exception {
        this.testCommitRollback();
        this.testConcurrentOpen();
        this.testThreeThreads();
    }

    public void testThreeThreads() throws Exception {
        this.deleteDb("multiConn");
        Connection conn1 = this.getConnection("multiConn");
        final Connection conn2 = this.getConnection("multiConn");
        final Connection conn3 = this.getConnection("multiConn");
        conn1.setAutoCommit(false);
        conn2.setAutoCommit(false);
        conn3.setAutoCommit(false);
        Statement s1 = conn1.createStatement();
        final Statement s2 = conn2.createStatement();
        final Statement s3 = conn3.createStatement();
        s1.execute("CREATE TABLE TEST1(ID INT)");
        s2.execute("CREATE TABLE TEST2(ID INT)");
        s3.execute("CREATE TABLE TEST3(ID INT)");
        s1.execute("INSERT INTO TEST1 VALUES(1)");
        s2.execute("INSERT INTO TEST2 VALUES(2)");
        s3.execute("INSERT INTO TEST3 VALUES(3)");
        Thread t1 = new Thread(new Runnable(){

            public void run() {
                try {
                    s3.execute("INSERT INTO TEST2 VALUES(4)");
                    conn3.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        t1.start();
        Thread.sleep(20L);
        Thread t2 = new Thread(new Runnable(){

            public void run() {
                try {
                    s2.execute("INSERT INTO TEST1 VALUES(5)");
                    conn2.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        t2.start();
        Thread.sleep(20L);
        conn1.commit();
        t2.join(100L);
        t1.join(100L);
        ResultSet rs = s1.executeQuery("SELECT * FROM TEST1 ORDER BY ID");
        rs.next();
        this.check(rs.getInt(1), 1L);
        rs.next();
        this.check(rs.getInt(1), 5L);
        this.checkFalse(rs.next());
        conn1.close();
        conn2.close();
        conn3.close();
    }

    public void testConcurrentOpen() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("multiConn");
        Connection conn = this.getConnection("multiConn");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        conn.createStatement().execute("INSERT INTO TEST VALUES(0, 'Hello'), (1, 'World')");
        conn.createStatement().execute("SHUTDOWN");
        conn.close();
        final String listener = this.getClass().getName();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Connection c1 = TestMultiConn.this.getConnection("multiConn;DATABASE_EVENT_LISTENER='" + listener + "';file_lock=socket");
                    c1.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        wait = 1000;
        Thread thread = new Thread(r);
        thread.start();
        Thread.sleep(10L);
        Connection c2 = this.getConnection("multiConn;file_lock=socket");
        c2.close();
        thread.join();
    }

    public void diskSpaceIsLow(long stillAvailable) throws SQLException {
    }

    public void exceptionThrown(SQLException e) {
    }

    public void setProgress(int state, String name, int x, int max) {
        while (wait > 0) {
            try {
                Thread.sleep(wait);
                wait = 0;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void closingDatabase() {
    }

    public void testCommitRollback() throws Exception {
        this.deleteDb("multiConn");
        Connection c1 = this.getConnection("multiConn");
        Connection c2 = this.getConnection("multiConn");
        c1.setAutoCommit(false);
        c2.setAutoCommit(false);
        Statement s1 = c1.createStatement();
        s1.execute("DROP TABLE IF EXISTS MULTI_A");
        s1.execute("CREATE TABLE MULTI_A(ID INT, NAME VARCHAR(255))");
        s1.execute("INSERT INTO MULTI_A VALUES(0, '0-insert-A')");
        Statement s2 = c2.createStatement();
        s1.execute("DROP TABLE IF EXISTS MULTI_B");
        s1.execute("CREATE TABLE MULTI_B(ID INT, NAME VARCHAR(255))");
        s2.execute("INSERT INTO MULTI_B VALUES(0, '1-insert-B')");
        c1.commit();
        c2.rollback();
        s1.execute("INSERT INTO MULTI_A VALUES(1, '0-insert-C')");
        s2.execute("INSERT INTO MULTI_B VALUES(1, '1-insert-D')");
        c1.rollback();
        c2.commit();
        c1.close();
        c2.close();
        if (!this.config.memory) {
            Connection conn = this.getConnection("multiConn");
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM MULTI_A ORDER BY ID");
            rs.next();
            this.check(rs.getString("NAME"), "0-insert-A");
            this.checkFalse(rs.next());
            rs = conn.createStatement().executeQuery("SELECT * FROM MULTI_B ORDER BY ID");
            rs.next();
            this.check(rs.getString("NAME"), "1-insert-D");
            this.checkFalse(rs.next());
            conn.close();
        }
    }
}

