/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.TestBase;
import org.h2.tools.FileBase;

public class TestLogFile
extends TestBase {
    private Connection conn;
    private static final int MAX_LOG_SIZE = 1;

    private long reconnect(int maxFiles) throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
        long length = 0L;
        ArrayList files = FileBase.getDatabaseFiles(BASE_DIR, "logfile", false);
        this.checkSmaller(files.size(), maxFiles + 2);
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.get(i);
            long len = new File(fileName).length();
            length += len;
        }
        this.conn = this.getConnection("logfile");
        return length;
    }

    public void test() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.deleteDb("logfile");
        this.reconnect(0);
        this.insert();
        int maxFiles = 3;
        for (int i = 0; i < 3; ++i) {
            long length = this.reconnect(maxFiles);
            this.insert();
            long l2 = this.reconnect(maxFiles);
            this.trace("l2=" + l2);
            this.check(l2 <= length * 2L);
        }
        this.conn.close();
    }

    private void checkLogSize() throws Exception {
        String[] files = new File(".").list();
        for (int j = 0; j < files.length; ++j) {
            String name = files[j];
            if (!name.startsWith("logfile") || !name.endsWith(".log.db")) continue;
            long length = new File(name).length();
            this.checkSmaller(length, 0x200000L);
        }
    }

    void insert() throws Exception {
        Statement stat = this.conn.createStatement();
        stat.execute("SET LOGSIZE 200");
        stat.execute("SET MAX_LOG_SIZE 1");
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Hello' || ?)");
        int len = this.getSize(1, 10000);
        for (int i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.setInt(2, i);
            prep.execute();
            if (i <= 0 || i % 2000 != 0) continue;
            this.checkLogSize();
        }
        this.checkLogSize();
    }
}

