/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import org.h2.test.TestBase;
import org.h2.test.bench.Bench;
import org.h2.test.bench.Database;

public class TestPerformance {
    boolean collect;

    public static void main(String[] args) throws Exception {
        new TestPerformance().test(args);
    }

    private Connection getResultConnection() throws Exception {
        Class.forName("org.h2.Driver");
        return DriverManager.getConnection("jdbc:h2:data/results");
    }

    private void openResults(boolean init) throws Exception {
        Connection conn = this.getResultConnection();
        if (init) {
            conn.createStatement().execute("DROP TABLE IF EXISTS RESULTS");
        }
        conn.createStatement().execute("CREATE TABLE IF NOT EXISTS RESULTS(TESTID INT, TEST VARCHAR, UNIT VARCHAR, DBID INT, DB VARCHAR, RESULT VARCHAR)");
        conn.close();
    }

    private void test(String[] args) throws Exception {
        boolean init = false;
        int dbId = -1;
        String out = "benchmark.html";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-db")) {
                dbId = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-init")) {
                init = true;
                continue;
            }
            if (!args[i].equals("-out")) continue;
            out = args[++i];
        }
        this.openResults(init);
        Properties prop = new Properties();
        prop.load(this.getClass().getResourceAsStream("test.properties"));
        int size = Integer.parseInt(prop.getProperty("size"));
        ArrayList<Database> dbs = new ArrayList<Database>();
        for (int i = 0; i < 100; ++i) {
            Database db;
            String dbString;
            if (dbId != -1 && i != dbId || (dbString = prop.getProperty("db" + i)) == null || (db = Database.parse(this, i, dbString)) == null) continue;
            db.setTranslations(prop);
            dbs.add(db);
        }
        ArrayList<Bench> tests = new ArrayList<Bench>();
        for (int i = 0; i < 100; ++i) {
            String testString = prop.getProperty("test" + i);
            if (testString == null) continue;
            Bench bench = (Bench)Class.forName(testString).newInstance();
            tests.add(bench);
        }
        this.testAll(dbs, tests, size);
        this.collect = false;
        if (dbs.size() == 0) {
            return;
        }
        ArrayList results = ((Database)dbs.get(0)).getResults();
        Connection conn = this.getResultConnection();
        PreparedStatement prep = conn.prepareStatement("INSERT INTO RESULTS(TESTID, TEST, UNIT, DBID, DB, RESULT) VALUES(?, ?, ?, ?, ?, ?)");
        for (int i = 0; i < results.size(); ++i) {
            Object[] res = (Object[])results.get(i);
            prep.setInt(1, i);
            prep.setString(2, res[0].toString());
            prep.setString(3, res[1].toString());
            for (int j = 0; j < dbs.size(); ++j) {
                Database db = (Database)dbs.get(j);
                prep.setInt(4, db.getId());
                prep.setString(5, db.getName());
                ArrayList r = db.getResults();
                Object[] v = (Object[])r.get(i);
                prep.setString(6, v[2].toString());
                prep.execute();
            }
        }
        PrintWriter writer = new PrintWriter(new FileWriter(out));
        ResultSet rs = conn.createStatement().executeQuery("CALL '<table><tr><th>Test Case</th><th>Unit</th>' || SELECT GROUP_CONCAT('<th>' || DB || '</th>' ORDER BY DBID SEPARATOR '') FROM  (SELECT DISTINCT DBID, DB FROM RESULTS)|| '</tr>' || SELECT GROUP_CONCAT('<tr><td>' || TEST || '</td><td>' || UNIT || '</td>' || ( SELECT GROUP_CONCAT('<td>' || RESULT || '</td>' ORDER BY DBID SEPARATOR '') FROM RESULTS R2 WHERE R2.TESTID = R1.TESTID) || '</tr>' ORDER BY TESTID SEPARATOR CHAR(10)) FROM (SELECT DISTINCT TESTID, TEST, UNIT FROM RESULTS) R1|| '</table>'");
        rs.next();
        String result = rs.getString(1);
        writer.println(result);
        conn.close();
        writer.close();
        System.out.println("Test finished");
        System.exit(0);
    }

    private void testAll(ArrayList dbs, ArrayList tests, int size) throws Exception {
        for (int i = 0; i < dbs.size(); ++i) {
            if (i > 0) {
                Thread.sleep(1000L);
            }
            TestBase.getMemoryUsed();
            Database db = (Database)dbs.get(i);
            System.out.println("testing " + db.getName());
            db.startServer();
            Connection conn = db.getConnection();
            this.runDatabase(db, tests, 1);
            this.runDatabase(db, tests, 1);
            this.collect = true;
            this.runDatabase(db, tests, size);
            conn.close();
            db.log("Executed Statements", "#", db.getExecutedStatements());
            db.log("Total Time", "ms", db.getTotalTime());
            db.log("Statement per Second", "#", db.getExecutedStatements() * 1000 / db.getTotalTime());
            this.collect = false;
            db.stopServer();
        }
    }

    private void runDatabase(Database db, ArrayList tests, int size) throws Exception {
        for (int j = 0; j < tests.size(); ++j) {
            Bench bench = (Bench)tests.get(j);
            this.runTest(db, bench, size);
        }
    }

    private void runTest(Database db, Bench bench, int size) throws Exception {
        bench.init(db, size);
        bench.run();
    }
}

