/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.bench;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import org.h2.test.bench.Bench;
import org.h2.test.bench.BenchCRandom;
import org.h2.test.bench.BenchCThread;
import org.h2.test.bench.Database;

public class BenchC
implements Bench {
    private Database db;
    int warehouses = 1;
    int items = 10000;
    int districtsPerWarehouse = 10;
    int customersPerDistrict = 300;
    private int ordersPerDistrict = 300;
    private BenchCRandom random;
    private String action;
    private int commitEvery = 1000;
    private static final String[] TABLES = new String[]{"WAREHOUSE", "DISTRICT", "CUSTOMER", "HISTORY", "ORDERS", "NEW_ORDER", "ITEM", "STOCK", "ORDER_LINE", "RESULTS"};
    private static final String[] CREATE_SQL = new String[]{"CREATE TABLE  WAREHOUSE(\n W_ID INT PRIMARY KEY,\n W_NAME VARCHAR(10),\n W_STREET_1 VARCHAR(20),\n W_STREET_2 VARCHAR(20),\n W_CITY VARCHAR(20),\n W_STATE CHAR(2),\n W_ZIP CHAR(9),\n W_TAX DECIMAL(4, 4),\n W_YTD DECIMAL(12, 2))", "CREATE TABLE  DISTRICT(\n D_ID INT,\n D_W_ID INT,\n D_NAME VARCHAR(10),\n D_STREET_1 VARCHAR(20),\n D_STREET_2 VARCHAR(20),\n D_CITY VARCHAR(20),\n D_STATE CHAR(2),\n D_ZIP CHAR(9),\n D_TAX DECIMAL(4, 4),\n D_YTD DECIMAL(12, 2),\n D_NEXT_O_ID INT,\n PRIMARY KEY (D_ID, D_W_ID))", "CREATE TABLE  CUSTOMER(\n C_ID INT,\n C_D_ID INT,\n C_W_ID INT,\n C_FIRST VARCHAR(16),\n C_MIDDLE CHAR(2),\n C_LAST VARCHAR(16),\n C_STREET_1 VARCHAR(20),\n C_STREET_2 VARCHAR(20),\n C_CITY VARCHAR(20),\n C_STATE CHAR(2),\n C_ZIP CHAR(9),\n C_PHONE CHAR(16),\n C_SINCE TIMESTAMP,\n C_CREDIT CHAR(2),\n C_CREDIT_LIM DECIMAL(12, 2),\n C_DISCOUNT DECIMAL(4, 4),\n C_BALANCE DECIMAL(12, 2),\n C_YTD_PAYMENT DECIMAL(12, 2),\n C_PAYMENT_CNT DECIMAL(4),\n C_DELIVERY_CNT DECIMAL(4),\n C_DATA VARCHAR(500),\n PRIMARY KEY (C_W_ID, C_D_ID, C_ID))", "CREATE INDEX CUSTOMER_NAME ON CUSTOMER(C_LAST, C_D_ID, C_W_ID)", "CREATE TABLE  HISTORY(\n H_C_ID INT,\n H_C_D_ID INT,\n H_C_W_ID INT,\n H_D_ID INT,\n H_W_ID INT,\n H_DATE TIMESTAMP,\n H_AMOUNT DECIMAL(6, 2),\n H_DATA VARCHAR(24))", "CREATE TABLE  ORDERS(\n O_ID INT,\n O_D_ID INT,\n O_W_ID INT,\n O_C_ID INT,\n O_ENTRY_D TIMESTAMP,\n O_CARRIER_ID INT,\n O_OL_CNT INT,\n O_ALL_LOCAL DECIMAL(1),\n PRIMARY KEY(O_W_ID, O_D_ID, O_ID))", "CREATE INDEX ORDERS_OID ON ORDERS(O_ID)", "CREATE TABLE  NEW_ORDER(\n NO_O_ID INT,\n NO_D_ID INT,\n NO_W_ID INT,\n PRIMARY KEY(NO_W_ID, NO_D_ID, NO_O_ID))", "CREATE TABLE  ITEM(\n I_ID INT,\n I_IM_ID INT,\n I_NAME VARCHAR(24),\n I_PRICE DECIMAL(5, 2),\n I_DATA VARCHAR(50),\n PRIMARY KEY(I_ID))", "CREATE TABLE  STOCK(\n S_I_ID INT,\n S_W_ID INT,\n S_QUANTITY DECIMAL(4),\n S_DIST_01 CHAR(24),\n S_DIST_02 CHAR(24),\n S_DIST_03 CHAR(24),\n S_DIST_04 CHAR(24),\n S_DIST_05 CHAR(24),\n S_DIST_06 CHAR(24),\n S_DIST_07 CHAR(24),\n S_DIST_08 CHAR(24),\n S_DIST_09 CHAR(24),\n S_DIST_10 CHAR(24),\n S_YTD DECIMAL(8),\n S_ORDER_CNT DECIMAL(4),\n S_REMOTE_CNT DECIMAL(4),\n S_DATA VARCHAR(50),\n PRIMARY KEY(S_W_ID, S_I_ID))", "CREATE TABLE  ORDER_LINE(\n OL_O_ID INT,\n OL_D_ID INT,\n OL_W_ID INT,\n OL_NUMBER INT,\n OL_I_ID INT,\n OL_SUPPLY_W_ID INT,\n OL_DELIVERY_D TIMESTAMP,\n OL_QUANTITY DECIMAL(2),\n OL_AMOUNT DECIMAL(6, 2),\n OL_DIST_INFO CHAR(24),\n PRIMARY KEY (OL_W_ID, OL_D_ID, OL_O_ID, OL_NUMBER))", "CREATE TABLE RESULTS(\n ID INT PRIMARY KEY,\n TERMINAL INT,\n OPERATION INT,\n RESPONSE_TIME INT,\n PROCESSING_TIME INT,\n KEYING_TIME INT,\n THINK_TIME INT,\n SUCCESSFULL INT,\n NOW TIMESTAMP)"};

    public void init(Database db, int size) throws Exception {
        this.db = db;
        this.random = new BenchCRandom();
        this.items = size * 10;
        this.warehouses = 1;
        this.districtsPerWarehouse = Math.max(1, size / 100);
        this.customersPerDistrict = Math.max(1, size / 100);
        this.ordersPerDistrict = Math.max(1, size / 1000);
        db.start(this, "Init");
        db.openConnection();
        this.load();
        db.commit();
        db.closeConnection();
        db.end();
        db.start(this, "Open/Close");
        db.openConnection();
        db.closeConnection();
        db.end();
    }

    private void load() throws Exception {
        int i;
        for (i = 0; i < TABLES.length; ++i) {
            this.db.dropTable(TABLES[i]);
        }
        for (i = 0; i < CREATE_SQL.length; ++i) {
            this.db.update(CREATE_SQL[i]);
        }
        this.db.setAutoCommit(false);
        this.loadItem();
        this.loadWarehouse();
        this.loadCustomer();
        this.loadOrder();
        this.db.commit();
        this.trace("load done");
    }

    void trace(String s) {
        this.action = s;
    }

    void trace(int i, int max) {
        this.db.trace(this.action, i, max);
    }

    private void loadItem() throws Exception {
        this.trace("load item");
        boolean[] original = this.random.getBoolean(this.items, this.items / 10);
        PreparedStatement prep = this.db.prepare("INSERT INTO ITEM(I_ID, I_IM_ID, I_NAME, I_PRICE, I_DATA) VALUES(?, ?, ?, ?, ?)");
        for (int i_id = 1; i_id <= this.items; ++i_id) {
            String i_name = this.random.getString(14, 24);
            BigDecimal i_price = this.random.getBigDecimal(this.random.getInt(100, 10000), 2);
            String i_data = this.random.getString(26, 50);
            if (original[i_id - 1]) {
                i_data = this.random.replace(i_data, "original");
            }
            prep.setInt(1, i_id);
            prep.setInt(2, this.random.getInt(1, 10000));
            prep.setString(3, i_name);
            prep.setBigDecimal(4, i_price);
            prep.setString(5, i_data);
            this.db.update(prep);
            this.trace(i_id, this.items);
            if (i_id % this.commitEvery != 0) continue;
            this.db.commit();
        }
    }

    private void loadWarehouse() throws Exception {
        this.trace("loading warehouses");
        PreparedStatement prep = this.db.prepare("INSERT INTO WAREHOUSE(W_ID, W_NAME, W_STREET_1, W_STREET_2, W_CITY, W_STATE, W_ZIP, W_TAX, W_YTD) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        for (int w_id = 1; w_id <= this.warehouses; ++w_id) {
            String w_name = this.random.getString(6, 10);
            String[] address = this.random.getAddress();
            String w_street_1 = address[0];
            String w_street_2 = address[1];
            String w_city = address[2];
            String w_state = address[3];
            String w_zip = address[4];
            BigDecimal w_tax = this.random.getBigDecimal(this.random.getInt(0, 2000), 4);
            BigDecimal w_ytd = new BigDecimal("300000.00");
            prep.setInt(1, w_id);
            prep.setString(2, w_name);
            prep.setString(3, w_street_1);
            prep.setString(4, w_street_2);
            prep.setString(5, w_city);
            prep.setString(6, w_state);
            prep.setString(7, w_zip);
            prep.setBigDecimal(8, w_tax);
            prep.setBigDecimal(9, w_ytd);
            this.db.update(prep);
            this.loadStock(w_id);
            this.loadDistrict(w_id);
            if (w_id % this.commitEvery != 0) continue;
            this.db.commit();
        }
    }

    private void loadCustomer() throws Exception {
        this.trace("load customers");
        int max = this.warehouses * this.districtsPerWarehouse;
        int i = 0;
        for (int w_id = 1; w_id <= this.warehouses; ++w_id) {
            for (int d_id = 1; d_id <= this.districtsPerWarehouse; ++d_id) {
                this.loadCustomerSub(d_id, w_id);
                this.trace(i++, max);
                if (i % this.commitEvery != 0) continue;
                this.db.commit();
            }
        }
    }

    private void loadCustomerSub(int d_id, int w_id) throws Exception {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        PreparedStatement prepCustomer = this.db.prepare("INSERT INTO CUSTOMER(C_ID, C_D_ID, C_W_ID, C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE, C_SINCE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_DATA, C_YTD_PAYMENT, C_PAYMENT_CNT, C_DELIVERY_CNT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement prepHistory = this.db.prepare("INSERT INTO HISTORY(H_C_ID, H_C_D_ID, H_C_W_ID, H_W_ID, H_D_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        for (int c_id = 1; c_id <= this.customersPerDistrict; ++c_id) {
            int c_d_id = d_id;
            int c_w_id = w_id;
            String c_first = this.random.getString(8, 16);
            String c_middle = "OE";
            String c_last = c_id < 1000 ? this.random.getLastname(c_id) : this.random.getLastname(this.random.getNonUniform(255, 0, 999));
            String[] address = this.random.getAddress();
            String c_street_1 = address[0];
            String c_street_2 = address[1];
            String c_city = address[2];
            String c_state = address[3];
            String c_zip = address[4];
            String c_phone = this.random.getNumberString(16, 16);
            String c_credit = this.random.getInt(0, 1) == 0 ? "GC" : "BC";
            BigDecimal c_discount = this.random.getBigDecimal(this.random.getInt(0, 5000), 4);
            BigDecimal c_balance = new BigDecimal("-10.00");
            BigDecimal c_credit_lim = new BigDecimal("50000.00");
            String c_data = this.random.getString(300, 500);
            BigDecimal c_ytd_payment = new BigDecimal("10.00");
            int c_payment_cnt = 1;
            int c_delivery_cnt = 1;
            prepCustomer.setInt(1, c_id);
            prepCustomer.setInt(2, c_d_id);
            prepCustomer.setInt(3, c_w_id);
            prepCustomer.setString(4, c_first);
            prepCustomer.setString(5, c_middle);
            prepCustomer.setString(6, c_last);
            prepCustomer.setString(7, c_street_1);
            prepCustomer.setString(8, c_street_2);
            prepCustomer.setString(9, c_city);
            prepCustomer.setString(10, c_state);
            prepCustomer.setString(11, c_zip);
            prepCustomer.setString(12, c_phone);
            prepCustomer.setTimestamp(13, timestamp);
            prepCustomer.setString(14, c_credit);
            prepCustomer.setBigDecimal(15, c_credit_lim);
            prepCustomer.setBigDecimal(16, c_discount);
            prepCustomer.setBigDecimal(17, c_balance);
            prepCustomer.setString(18, c_data);
            prepCustomer.setBigDecimal(19, c_ytd_payment);
            prepCustomer.setInt(20, c_payment_cnt);
            prepCustomer.setInt(21, c_delivery_cnt);
            this.db.update(prepCustomer);
            BigDecimal h_amount = new BigDecimal("10.00");
            String h_data = this.random.getString(12, 24);
            prepHistory.setInt(1, c_id);
            prepHistory.setInt(2, c_d_id);
            prepHistory.setInt(3, c_w_id);
            prepHistory.setInt(4, c_w_id);
            prepHistory.setInt(5, c_d_id);
            prepHistory.setTimestamp(6, timestamp);
            prepHistory.setBigDecimal(7, h_amount);
            prepHistory.setString(8, h_data);
            this.db.update(prepHistory);
        }
    }

    private void loadOrder() throws Exception {
        this.trace("load orders");
        int max = this.warehouses * this.districtsPerWarehouse;
        int i = 0;
        for (int w_id = 1; w_id <= this.warehouses; ++w_id) {
            for (int d_id = 1; d_id <= this.districtsPerWarehouse; ++d_id) {
                this.loadOrderSub(d_id, w_id);
                this.trace(i++, max);
            }
        }
    }

    private void loadOrderSub(int d_id, int w_id) throws Exception {
        int o_d_id = d_id;
        int o_w_id = w_id;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        int[] orderid = this.random.getPermutation(this.ordersPerDistrict);
        PreparedStatement prepOrder = this.db.prepare("INSERT INTO ORDERS(O_ID, O_C_ID, O_D_ID, O_W_ID, O_ENTRY_D, O_CARRIER_ID, O_OL_CNT, O_ALL_LOCAL) VALUES(?, ?, ?, ?, ?, ?, ?, 1)");
        PreparedStatement prepNewOrder = this.db.prepare("INSERT INTO NEW_ORDER (NO_O_ID, NO_D_ID, NO_W_ID) VALUES (?, ?, ?)");
        PreparedStatement prepLine = this.db.prepare("INSERT INTO ORDER_LINE(OL_O_ID, OL_D_ID, OL_W_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO, OL_DELIVERY_D)VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NULL)");
        int i = 0;
        for (int o_id = 1; o_id <= this.ordersPerDistrict; ++o_id) {
            int o_c_id = orderid[o_id - 1];
            int o_carrier_id = this.random.getInt(1, 10);
            int o_ol_cnt = this.random.getInt(5, 15);
            prepOrder.setInt(1, o_id);
            prepOrder.setInt(2, o_c_id);
            prepOrder.setInt(3, o_d_id);
            prepOrder.setInt(4, o_w_id);
            prepOrder.setTimestamp(5, timestamp);
            prepOrder.setInt(7, o_ol_cnt);
            if (o_id <= 2100) {
                prepOrder.setInt(6, o_carrier_id);
            } else {
                prepOrder.setNull(6, 4);
                prepNewOrder.setInt(1, o_id);
                prepNewOrder.setInt(2, o_d_id);
                prepNewOrder.setInt(3, o_w_id);
                this.db.update(prepNewOrder);
            }
            this.db.update(prepOrder);
            for (int ol = 1; ol <= o_ol_cnt; ++ol) {
                int ol_i_id = this.random.getInt(1, this.items);
                int ol_supply_w_id = o_w_id;
                int ol_quantity = 5;
                String ol_dist_info = this.random.getString(24);
                BigDecimal ol_amount = o_id < 2101 ? this.random.getBigDecimal(0, 2) : this.random.getBigDecimal(this.random.getInt(0, 1000000), 2);
                prepLine.setInt(1, o_id);
                prepLine.setInt(2, o_d_id);
                prepLine.setInt(3, o_w_id);
                prepLine.setInt(4, ol);
                prepLine.setInt(5, ol_i_id);
                prepLine.setInt(6, ol_supply_w_id);
                prepLine.setInt(7, ol_quantity);
                prepLine.setBigDecimal(8, ol_amount);
                prepLine.setString(9, ol_dist_info);
                this.db.update(prepLine);
                if (i++ % this.commitEvery != 0) continue;
                this.db.commit();
            }
        }
    }

    private void loadStock(int w_id) throws Exception {
        this.trace("load stock (warehouse " + w_id + ")");
        int s_w_id = w_id;
        boolean[] original = this.random.getBoolean(this.items, this.items / 10);
        PreparedStatement prep = this.db.prepare("INSERT INTO STOCK(S_I_ID, S_W_ID, S_QUANTITY, S_DIST_01, S_DIST_02, S_DIST_03, S_DIST_04, S_DIST_05, S_DIST_06, S_DIST_07, S_DIST_08, S_DIST_09, S_DIST_10, S_DATA, S_YTD, S_ORDER_CNT, S_REMOTE_CNT) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        for (int s_i_id = 1; s_i_id <= this.items; ++s_i_id) {
            int s_quantity = this.random.getInt(10, 100);
            String s_dist_01 = this.random.getString(24);
            String s_dist_02 = this.random.getString(24);
            String s_dist_03 = this.random.getString(24);
            String s_dist_04 = this.random.getString(24);
            String s_dist_05 = this.random.getString(24);
            String s_dist_06 = this.random.getString(24);
            String s_dist_07 = this.random.getString(24);
            String s_dist_08 = this.random.getString(24);
            String s_dist_09 = this.random.getString(24);
            String s_dist_10 = this.random.getString(24);
            String s_data = this.random.getString(26, 50);
            if (original[s_i_id - 1]) {
                s_data = this.random.replace(s_data, "original");
            }
            prep.setInt(1, s_i_id);
            prep.setInt(2, s_w_id);
            prep.setInt(3, s_quantity);
            prep.setString(4, s_dist_01);
            prep.setString(5, s_dist_02);
            prep.setString(6, s_dist_03);
            prep.setString(7, s_dist_04);
            prep.setString(8, s_dist_05);
            prep.setString(9, s_dist_06);
            prep.setString(10, s_dist_07);
            prep.setString(11, s_dist_08);
            prep.setString(12, s_dist_09);
            prep.setString(13, s_dist_10);
            prep.setString(14, s_data);
            prep.setInt(15, 0);
            prep.setInt(16, 0);
            prep.setInt(17, 0);
            this.db.update(prep);
            if (s_i_id % this.commitEvery == 0) {
                this.db.commit();
            }
            this.trace(s_i_id, this.items);
        }
    }

    private void loadDistrict(int w_id) throws Exception {
        int d_w_id = w_id;
        BigDecimal d_ytd = new BigDecimal("300000.00");
        int d_next_o_id = 3001;
        PreparedStatement prep = this.db.prepare("INSERT INTO DISTRICT(D_ID, D_W_ID, D_NAME, D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP, D_TAX, D_YTD, D_NEXT_O_ID) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        for (int d_id = 1; d_id <= this.districtsPerWarehouse; ++d_id) {
            String d_name = this.random.getString(6, 10);
            String[] address = this.random.getAddress();
            String d_street_1 = address[0];
            String d_street_2 = address[1];
            String d_city = address[2];
            String d_state = address[3];
            String d_zip = address[4];
            BigDecimal d_tax = this.random.getBigDecimal(this.random.getInt(0, 2000), 4);
            prep.setInt(1, d_id);
            prep.setInt(2, d_w_id);
            prep.setString(3, d_name);
            prep.setString(4, d_street_1);
            prep.setString(5, d_street_2);
            prep.setString(6, d_city);
            prep.setString(7, d_state);
            prep.setString(8, d_zip);
            prep.setBigDecimal(9, d_tax);
            prep.setBigDecimal(10, d_ytd);
            prep.setInt(11, d_next_o_id);
            this.db.update(prep);
            this.trace(d_id, this.districtsPerWarehouse);
        }
    }

    public void run() throws Exception {
        this.db.start(this, "Transactions");
        this.db.openConnection();
        for (int i = 0; i < 50; ++i) {
            BenchCThread process = new BenchCThread(this.db, this, this.random, i);
            process.process();
        }
        this.db.closeConnection();
        this.db.end();
        this.db.openConnection();
        BenchCThread process = new BenchCThread(this.db, this, this.random, 0);
        process.process();
        this.db.logMemory(this, "Memory Usage");
        this.db.closeConnection();
    }

    public String getName() {
        return "BenchC";
    }
}

