/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Schema;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class TableView
extends Table {
    private String querySQL;
    private ObjectArray params;
    private ObjectArray tables;
    private boolean invalid;

    public TableView(Schema schema, int id, String name, String querySQL, ObjectArray params, Session session) throws SQLException {
        super(schema, id, name, false);
        this.querySQL = querySQL;
        this.params = params;
        this.initColumnsAndTables(session);
    }

    private void initColumnsAndTables(Session session) throws SQLException {
        Object[] cols;
        try {
            Query query = (Query)session.prepare(this.querySQL);
            this.tables = new ObjectArray(query.getTables());
            ObjectArray expressions = query.getExpressions();
            ObjectArray list = new ObjectArray();
            for (int i = 0; i < query.getColumnCount(); ++i) {
                Expression expr = (Expression)expressions.get(i);
                String name = expr.getAlias();
                int type = expr.getType();
                long precision = expr.getPrecision();
                int scale = expr.getScale();
                Column col = new Column(name, type, precision, scale);
                col.setTable(this, i);
                list.add(col);
            }
            cols = new Column[list.size()];
            list.toArray(cols);
            this.invalid = false;
        }
        catch (SQLException e) {
            this.tables = new ObjectArray();
            cols = new Column[]{};
            this.invalid = true;
        }
        this.setColumns((Column[])cols);
    }

    public boolean getInvalid() {
        return this.invalid;
    }

    public PlanItem getBestPlanItem(Session session, int[] masks) throws SQLException {
        ViewIndex index = new ViewIndex(this, this.querySQL, this.params);
        Query query = index.getQuery(session, masks);
        PlanItem item = new PlanItem();
        item.cost = query.getCost();
        item.index = index;
        return item;
    }

    public String getCreateSQL() {
        return "CREATE FORCE VIEW " + this.getSQL() + " AS " + this.querySQL;
    }

    public void checkRename() throws SQLException {
    }

    public void lock(Session session, boolean exclusive) throws SQLException {
    }

    public void close(Session session) throws SQLException {
    }

    public void unlock(Session s) {
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public void removeIndex(String indexName) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Index addIndex(Session session, String indexName, int indexId, Column[] cols, IndexType indexType, int headPos) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public int getRowCount() {
        throw Message.internal();
    }

    public boolean canGetRowCount() {
        return false;
    }

    public String getTableType() {
        return "VIEW";
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        super.removeChildrenAndResources(session);
        for (int i = 0; i < this.tables.size(); ++i) {
            Table t = (Table)this.tables.get(i);
            t.removeView(this);
        }
        this.querySQL = null;
        this.invalidate();
    }

    public Index getScanIndex(Session session) throws SQLException {
        PlanItem item = this.getBestPlanItem(session, null);
        return item.index;
    }

    public ObjectArray getIndexes() {
        return null;
    }

    public ObjectArray getTables() {
        return this.tables;
    }

    public void recompile(Session session) throws SQLException {
        this.initColumnsAndTables(session);
    }
}

