/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.FileStore;
import org.h2.util.MathUtils;

public class FileStoreInputStream
extends InputStream {
    private FileStore store;
    private DataPage page;
    private int remaining;

    public FileStoreInputStream(FileStore store, DataHandler handler) throws SQLException {
        this.store = store;
        this.page = DataPage.create(handler, 16);
        try {
            if (store.length() <= 48L) {
                this.close();
            } else {
                this.fillBuffer();
            }
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public int read(byte[] buff, int off, int len) throws IOException {
        this.fillBuffer();
        if (this.store == null) {
            return -1;
        }
        int l = Math.min(this.remaining, len);
        this.page.read(buff, off, l);
        this.remaining -= l;
        return l;
    }

    private void fillBuffer() throws IOException {
        if (this.remaining > 0 || this.store == null) {
            return;
        }
        this.page.reset();
        try {
            this.store.readFully(this.page.getBytes(), 0, 16);
        }
        catch (SQLException e) {
            throw Message.convertToIOException(e);
        }
        this.page.reset();
        this.remaining = this.page.readInt();
        if (this.remaining < 0) {
            this.close();
            return;
        }
        this.page.checkCapacity(this.remaining);
        int len = MathUtils.roundUp(this.remaining + 2 + this.page.getIntLen(), 16) - 16;
        try {
            this.store.readFully(this.page.getBytes(), 16, len);
        }
        catch (SQLException e) {
            throw Message.convertToIOException(e);
        }
        this.page.reset();
        this.page.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.store != null) {
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }

    public void finalize() {
        if (!Constants.RUN_FINALIZERS) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int read() throws IOException {
        this.fillBuffer();
        if (this.store == null) {
            return -1;
        }
        int i = this.page.readByte() & 0xFF;
        --this.remaining;
        return i;
    }
}

