/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.sql.SQLException;
import org.h2.store.DataPage;
import org.h2.store.Record;
import org.h2.value.Value;

public class Row
extends Record {
    private Value[] data;

    public Row(Value[] data) {
        this.data = data;
    }

    public Row(Row old) {
        this.data = old.data;
    }

    public Row() {
    }

    public Value getValue(int i) {
        return this.data[i];
    }

    public void write(DataPage buff) throws SQLException {
        buff.writeInt(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            Value v = this.data[i];
            buff.writeValue(v);
        }
    }

    public int getByteCount(DataPage dummy) throws SQLException {
        int len = this.data.length;
        int size = dummy.getIntLen();
        for (int i = 0; i < len; ++i) {
            Value v = this.data[i];
            size += dummy.getValueLen(v);
        }
        return size;
    }

    public void setValue(int i, Value v) {
        this.data[i] = v;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public int getColumnCount() {
        return this.data.length;
    }
}

