/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.h2.engine.SessionInterface;
import org.h2.message.Message;
import org.h2.message.TraceObject;
import org.h2.util.TypeConverter;
import org.h2.value.Value;

public class JdbcClob
extends TraceObject
implements Clob {
    private Value value;

    JdbcClob(SessionInterface session, Value value, int id) {
        this.setTrace(session.getTrace(), 4, id);
        this.value = value;
    }

    public long length() throws SQLException {
        try {
            int len;
            long precision;
            this.infoCodeCall("length");
            if (this.value.getType() == 16 && (precision = this.value.getPrecision()) > 0L) {
                return precision;
            }
            Reader in = this.value.getReader();
            long size = 0L;
            char[] buff = new char[16];
            while ((len = in.read(buff, 0, 16)) > 0) {
                size += (long)len;
            }
            return size;
        }
        catch (Throwable e) {
            throw Message.convert(e);
        }
    }

    public void truncate(long len) throws SQLException {
        this.infoCodeCall("truncate", len);
        throw Message.getUnsupportedException();
    }

    public InputStream getAsciiStream() throws SQLException {
        try {
            this.infoCodeCall("getAsciiStream");
            String s = this.value.getString();
            return s == null ? null : TypeConverter.getInputStream(s);
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.infoCodeCall("setAsciiStream", pos);
        throw Message.getUnsupportedException();
    }

    public Reader getCharacterStream() throws SQLException {
        try {
            this.infoCodeCall("getCharacterStream");
            return this.value.getReader();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.infoCodeCall("setCharacterStream", pos);
        throw Message.getUnsupportedException();
    }

    public String getSubString(long pos, int length) throws SQLException {
        try {
            this.infoCode("getSubString(" + pos + ", " + length + ");");
            if (pos < 1L) {
                throw Message.getInvalidValueException("pos", "" + pos);
            }
            if (length < 0) {
                throw Message.getInvalidValueException("length", "" + length);
            }
            Reader reader = this.value.getReader();
            StringBuffer buff = new StringBuffer();
            try {
                int ch;
                reader.skip(pos - 1L);
                for (int i = 0; i < length && (ch = reader.read()) >= 0; ++i) {
                    buff.append((char)ch);
                }
            }
            catch (IOException e) {
                Message.convert(e);
            }
            return buff.toString();
        }
        catch (Throwable e) {
            throw this.logAndConvert(e);
        }
    }

    public int setString(long pos, String str) throws SQLException {
        this.infoCode("setString(" + pos + ", " + this.quote(str) + ");");
        throw Message.getUnsupportedException();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.infoCode("setString(" + pos + ", " + this.quote(str) + ", " + offset + ", " + len + ");");
        throw Message.getUnsupportedException();
    }

    public long position(String pattern, long start) throws SQLException {
        this.infoCode("position(" + this.quote(pattern) + ", " + start + ");");
        throw Message.getUnsupportedException();
    }

    public long position(Clob clobPattern, long start) throws SQLException {
        this.infoCode("position(clobPattern, " + start + ");");
        throw Message.getUnsupportedException();
    }
}

