/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Expression;
import org.h2.expression.Function;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class Operation
extends Expression {
    public static final int CONCAT = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int NEGATE = 5;
    private int opType;
    private Expression left;
    private Expression right;
    private int dataType;

    public Operation(int opType, Expression left, Expression right) {
        this.opType = opType;
        this.left = left;
        this.right = right;
    }

    /*
     * WARNING - void declaration
     */
    public String getSQL() {
        void var1_1;
        switch (this.opType) {
            case 5: {
                String sql = "- " + this.left.getSQL();
                break;
            }
            case 0: {
                String sql = this.left.getSQL() + " || " + this.right.getSQL();
                break;
            }
            case 1: {
                String sql = this.left.getSQL() + " + " + this.right.getSQL();
                break;
            }
            case 2: {
                String sql = this.left.getSQL() + " - " + this.right.getSQL();
                break;
            }
            case 3: {
                String sql = this.left.getSQL() + " * " + this.right.getSQL();
                break;
            }
            case 4: {
                String sql = this.left.getSQL() + " / " + this.right.getSQL();
                break;
            }
            default: {
                throw Message.internal("opType=" + this.opType);
            }
        }
        return "(" + (String)var1_1 + ")";
    }

    public Value getValue(SessionInterface session) throws SQLException {
        Value l = this.left.getValue(session).convertTo(this.dataType);
        Value r = this.right == null ? null : this.right.getValue(session).convertTo(this.dataType);
        switch (this.opType) {
            case 5: {
                return l == ValueNull.INSTANCE ? l : l.negate();
            }
            case 0: {
                if (l == ValueNull.INSTANCE) {
                    if (Mode.getCurrentMode().nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return r;
                }
                if (r == ValueNull.INSTANCE) {
                    if (Mode.getCurrentMode().nullConcatIsNull) {
                        return ValueNull.INSTANCE;
                    }
                    return l;
                }
                String s1 = l.getString();
                String s2 = r.getString();
                StringBuffer buff = new StringBuffer(s1.length() + s2.length());
                buff.append(s1);
                buff.append(s2);
                return ValueString.get(buff.toString());
            }
            case 1: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.add(r);
            }
            case 2: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.subtract(r);
            }
            case 3: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.multiply(r);
            }
            case 4: {
                if (l == ValueNull.INSTANCE || r == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                return l.divide(r);
            }
        }
        throw Message.internal("type=" + this.opType);
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        this.left.mapColumns(tableFilter, level);
        if (this.right != null) {
            this.right.mapColumns(tableFilter, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        this.left = this.left.optimize(session);
        switch (this.opType) {
            case 5: {
                this.dataType = this.left.getType();
                break;
            }
            case 0: {
                this.right = this.right.optimize(session);
                this.dataType = 13;
                if (!this.left.isConstant() || !this.right.isConstant()) break;
                return ValueExpression.get(this.getValue(session));
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.right = this.right.optimize(session);
                int l = this.left.getType();
                int r = this.right.getType();
                if (l == 10 || l == 11) {
                    if (r == 4 && (this.opType == 1 || this.opType == 2)) {
                        Function f = Function.getFunction(session.getDatabase(), "DATEADD");
                        f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                        if (this.opType == 2) {
                            this.right = new Operation(5, this.right, null);
                            this.right = this.right.optimize(session);
                        }
                        f.setParameter(1, this.right);
                        f.setParameter(2, this.left);
                        f.doneWithParameters();
                        return f.optimize(session);
                    }
                    if (this.opType != 2 || l != 10 && l != 11) break;
                    Function f = Function.getFunction(session.getDatabase(), "DATEDIFF");
                    f.setParameter(0, ValueExpression.get(ValueString.get("DAY")));
                    f.setParameter(1, this.right);
                    f.setParameter(2, this.left);
                    f.doneWithParameters();
                    return f.optimize(session);
                }
                this.dataType = Value.getHigherOrder(l, r);
                break;
            }
            default: {
                throw Message.internal("type=" + this.opType);
            }
        }
        if (this.left.isConstant() && (this.right == null || this.right.isConstant())) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public boolean isEvaluatable(int filterLevel) {
        if (this.right != null) {
            return this.left.isEvaluatable(filterLevel) && this.right.isEvaluatable(filterLevel);
        }
        return this.left.isEvaluatable(filterLevel);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        if (this.right != null) {
            this.right.setEvaluatable(tableFilter, b);
        }
    }

    public int getType() {
        return this.dataType;
    }

    public long getPrecision() {
        if (this.right != null) {
            return Math.max(this.left.getPrecision(), this.right.getPrecision());
        }
        return this.left.getPrecision();
    }

    public int getScale() {
        if (this.right != null) {
            return Math.max(this.left.getScale(), this.right.getScale());
        }
        return this.left.getScale();
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        if (this.right != null) {
            this.right.updateAggregate(session);
        }
    }
}

