/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.engine.SessionInterface;
import org.h2.expression.Condition;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ValueExpression;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class CompareLike
extends Condition {
    private Expression left;
    private Expression right;
    private char escape;
    private boolean isInit;
    private char[] pattern;
    private int[] types;
    private int patternLength;
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private boolean ignoreCase;

    public CompareLike(Expression left, Expression right, char escape) {
        this.left = left;
        this.right = right;
        this.escape = escape;
    }

    public String getSQL() {
        String sql = this.left.getSQL() + " LIKE " + this.right.getSQL();
        if (this.escape != '\\') {
            sql = sql + " ESCAPE '" + this.escape + "'";
        }
        return "(" + sql + ")";
    }

    public Expression optimize(Session session) throws SQLException {
        Value l;
        this.left = this.left.optimize(session);
        this.right = this.right.optimize(session);
        if (this.left.getType() == 14) {
            this.ignoreCase = true;
        }
        if (this.left.isConstant() && (l = this.left.getValue(session)) == ValueNull.INSTANCE) {
            return ValueExpression.NULL;
        }
        if (this.right.isConstant()) {
            if (this.left.isConstant()) {
                return ValueExpression.get(this.getValue(session));
            }
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return ValueExpression.NULL;
            }
            String pattern = r.getString();
            this.initPattern(pattern);
            this.isInit = true;
        }
        return this;
    }

    public void mapColumns(TableFilter tableFilter, int level) throws SQLException {
        this.left.mapColumns(tableFilter, level);
        this.right.mapColumns(tableFilter, level);
    }

    public void createIndexConditions(TableFilter filter) throws SQLException {
        Session session = filter.getSession();
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (!this.right.isConstant()) {
            return;
        }
        String p = this.right.getValue(session).getString();
        this.initPattern(p);
        if (this.patternLength <= 0 || this.types[0] != 0) {
            return;
        }
        int dataType = l.getColumn().getType();
        if (dataType != 13 && dataType != 14) {
            return;
        }
        int maxMatch = 0;
        StringBuffer buff = new StringBuffer();
        while (maxMatch < this.patternLength && this.types[maxMatch] == 0) {
            buff.append(this.pattern[maxMatch++]);
        }
        String begin = buff.toString();
        if (maxMatch == this.patternLength) {
            filter.addIndexCondition(new IndexCondition(0, l, ValueExpression.get(ValueString.get(begin))));
        } else {
            String end = begin + '\uffff';
            filter.addIndexCondition(new IndexCondition(1, l, ValueExpression.get(ValueString.get(begin))));
            filter.addIndexCondition(new IndexCondition(3, l, ValueExpression.get(ValueString.get(end))));
        }
    }

    public boolean isEvaluatable(int filterLevel) {
        return this.left.isEvaluatable(filterLevel) && this.right.isEvaluatable(filterLevel);
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
        this.right.setEvaluatable(tableFilter, b);
    }

    public void updateAggregate(Session session) throws SQLException {
        this.left.updateAggregate(session);
        this.right.updateAggregate(session);
    }

    public Value getValue(SessionInterface session) throws SQLException {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        if (!this.isInit) {
            Value r = this.right.getValue(session);
            if (r == ValueNull.INSTANCE) {
                return r;
            }
            String pattern = r.getString();
            this.initPattern(pattern);
        }
        String value = l.getString();
        boolean result = this.compareAt(value, 0, 0, value.length());
        return ValueBoolean.get(result);
    }

    private boolean compare(String s, int pi, int si) {
        if (this.ignoreCase) {
            return Character.toUpperCase(this.pattern[pi]) == Character.toUpperCase(s.charAt(si));
        }
        return this.pattern[pi] == s.charAt(si);
    }

    private boolean compareAt(String s, int pi, int si, int slen) {
        while (pi < this.patternLength) {
            int type = this.types[pi];
            switch (type) {
                case 0: {
                    if (si < slen && this.compare(s, pi, si++)) break;
                    return false;
                }
                case 1: {
                    if (si++ < slen) break;
                    return false;
                }
                case 2: {
                    if (++pi >= this.patternLength) {
                        return true;
                    }
                    while (si < slen) {
                        if (this.compare(s, pi, si) && this.compareAt(s, pi, si, slen)) {
                            return true;
                        }
                        ++si;
                    }
                    return false;
                }
                default: {
                    throw Message.internal("type=" + type);
                }
            }
            ++pi;
        }
        return si == slen;
    }

    public boolean test(String pattern, String value) throws SQLException {
        this.initPattern(pattern);
        return this.compareAt(value, 0, 0, value.length());
    }

    private void initPattern(String p) throws SQLException {
        int i;
        this.patternLength = 0;
        if (p == null) {
            this.types = null;
            this.pattern = null;
            return;
        }
        int len = p.length();
        this.pattern = new char[len];
        this.types = new int[len];
        boolean lastAny = false;
        for (i = 0; i < len; ++i) {
            int type;
            char c = p.charAt(i);
            if (this.escape == c) {
                if (i >= len - 1) {
                    throw Message.getSQLException(22025);
                }
                if ((c = p.charAt(++i)) != '_' && c != '%' && c != this.escape) {
                    throw Message.getSQLException(22025);
                }
                type = 0;
            } else if (c == '%') {
                if (lastAny) continue;
                type = 2;
                lastAny = true;
            } else if (c == '_') {
                type = 1;
            } else {
                type = 0;
                lastAny = false;
            }
            this.types[this.patternLength] = type;
            this.pattern[this.patternLength++] = c;
        }
        for (i = 0; i < this.patternLength - 1; ++i) {
            if (this.types[i] != 2 || this.types[i + 1] != 1) continue;
            this.types[i] = 1;
            this.types[i + 1] = 2;
        }
    }
}

