/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.SQLException;
import org.h2.command.CommandInterface;
import org.h2.command.CommandRemote;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.util.FileUtils;
import org.h2.util.NetUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Transfer;
import org.h2.value.ValueLob;

public class SessionRemote
implements SessionInterface {
    public static final int SESSION_PREPARE = 0;
    public static final int SESSION_CLOSE = 1;
    public static final int COMMAND_EXECUTE_QUERY = 2;
    public static final int COMMAND_EXECUTE_UPDATE = 3;
    public static final int COMMAND_CLOSE = 4;
    public static final int RESULT_FETCH_ROW = 5;
    public static final int RESULT_RESET = 6;
    public static final int RESULT_CLOSE = 7;
    public static final int COMMAND_COMMIT = 8;
    public static final int STATUS_ERROR = 0;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CLOSED = 2;
    private TraceSystem traceSystem;
    private Trace trace;
    private ObjectArray transferList;
    private int nextId;
    private boolean autoCommit = true;
    private CommandInterface switchOffAutoCommit;
    private ConnectionInfo connectionInfo;

    private Transfer initTransfer(ConnectionInfo ci, String db, String server) throws IOException, SQLException {
        int port = 9092;
        int startIndex = server.startsWith("[") ? server.indexOf(93) : 0;
        int idx = server.indexOf(58, startIndex);
        if (idx >= 0) {
            port = Integer.parseInt(server.substring(idx + 1));
            server = server.substring(0, idx);
        }
        InetAddress address = InetAddress.getByName(server);
        Socket socket = NetUtils.createSocket(address, port, ci.isSSL());
        Transfer trans = new Transfer();
        trans.setSocket(socket);
        trans.init();
        trans.writeInt(3);
        trans.writeString(db);
        trans.writeString(ci.getOriginalURL());
        trans.writeString(ci.getUserName());
        trans.writeBytes(ci.getUserPasswordHash());
        trans.writeBytes(ci.getFilePasswordHash());
        String[] keys = ci.getKeys();
        trans.writeInt(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            trans.writeString(key).writeString(ci.getProperty(key));
        }
        try {
            this.done(trans);
        }
        catch (SQLException e) {
            trans.close();
            throw e;
        }
        this.autoCommit = true;
        return trans;
    }

    private void switchOffAutocommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList.size() > 1) {
            if (this.switchOffAutoCommit == null) {
                this.switchOffAutoCommit = this.prepareCommand("SET AUTOCOMMIT FALSE");
            }
            this.switchOffAutoCommit.executeUpdate();
            this.autoCommit = true;
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void autoCommitIfCluster() throws SQLException {
        if (this.autoCommit && this.transferList != null && this.transferList.size() > 1) {
            for (int i = 0; i < this.transferList.size(); ++i) {
                Transfer transfer = (Transfer)this.transferList.get(i);
                try {
                    this.traceOperation("COMMAND_COMMIT", 0);
                    transfer.writeInt(8);
                    this.done(transfer);
                    continue;
                }
                catch (IOException e) {
                    this.removeServer(i);
                }
            }
        }
    }

    private String getTraceFilePrefix(String dbName) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < dbName.length(); ++i) {
            char ch = dbName.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                buff.append(ch);
                continue;
            }
            buff.append('_');
        }
        return buff.toString();
    }

    public SessionRemote() {
    }

    public int getPowerOffCount() {
        return 0;
    }

    public void setPowerOffCount(int count) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public SessionInterface createSession(ConnectionInfo ci) throws SQLException {
        return new SessionRemote(ci);
    }

    private SessionRemote(ConnectionInfo ci) throws SQLException {
        this.connectionInfo = ci;
        this.connect();
    }

    private void connect() throws SQLException {
        int idx;
        ConnectionInfo ci = this.connectionInfo;
        String name = ci.getName();
        if (name.startsWith("//")) {
            name = name.substring("//".length());
        }
        if ((idx = name.indexOf(47)) < 0) {
            throw ci.getFormatException();
        }
        String db = name.substring(idx + 1);
        String server = name.substring(0, idx);
        this.traceSystem = new TraceSystem(null);
        try {
            String traceLevelSystemOut;
            String traceLevelFile = ci.getProperty("TRACE_LEVEL_FILE");
            if (traceLevelFile != null) {
                int level = Integer.parseInt(traceLevelFile);
                String prefix = this.getTraceFilePrefix(db);
                String file = FileUtils.createTempFile(prefix, ".trace.db", false);
                this.traceSystem.setFileName(file);
                this.traceSystem.setLevelFile(level);
            }
            if ((traceLevelSystemOut = ci.getProperty("TRACE_LEVEL_SYSTEM_OUT")) != null) {
                int level = Integer.parseInt(traceLevelSystemOut);
                this.traceSystem.setLevelSystemOut(level);
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
        this.trace = this.traceSystem.getTrace("jdbc");
        this.transferList = new ObjectArray();
        String serverlist = null;
        if (server.indexOf(44) >= 0) {
            serverlist = StringUtils.quoteStringSQL(server);
            ci.setProperty("CLUSTER", serverlist);
        }
        String[] servers = StringUtils.arraySplit(server, ',');
        int len = servers.length;
        this.transferList = new ObjectArray();
        boolean switchOffCluster = false;
        for (int i = 0; i < len; ++i) {
            try {
                Transfer trans = this.initTransfer(ci, db, servers[i]);
                this.transferList.add(trans);
                continue;
            }
            catch (IOException e) {
                switchOffCluster = true;
            }
        }
        this.checkClosed();
        if (switchOffCluster) {
            this.switchOffCluster();
        }
        this.switchOffAutocommitIfCluster();
    }

    private void switchOffCluster() throws SQLException {
        CommandInterface ci = this.prepareCommand("SET CLUSTER ''");
        ci.executeUpdate();
    }

    public void removeServer(int i) throws SQLException {
        this.transferList.remove(i);
        this.checkClosed();
        this.switchOffCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandInterface prepareCommand(String sql) throws SQLException {
        SessionRemote sessionRemote = this;
        synchronized (sessionRemote) {
            this.checkClosed();
            return new CommandRemote(this, this.transferList, sql);
        }
    }

    public void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw Message.getSQLException(90067);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.transferList != null) {
            SessionRemote sessionRemote = this;
            synchronized (sessionRemote) {
                for (int i = 0; i < this.transferList.size(); ++i) {
                    Transfer transfer = (Transfer)this.transferList.get(i);
                    try {
                        this.traceOperation("SESSION_CLOSE", 0);
                        transfer.writeInt(1);
                        this.done(transfer);
                        transfer.close();
                        continue;
                    }
                    catch (Exception e) {
                        this.trace.error("close", e);
                    }
                }
            }
            this.transferList = null;
        }
        this.traceSystem.close();
    }

    public Trace getTrace() {
        return this.traceSystem.getTrace("jdbc");
    }

    public int getNextId() {
        return this.nextId++;
    }

    public int getCurrentId() {
        return this.nextId;
    }

    public ValueLob createClob(Reader in, int length) throws SQLException {
        ValueLob lob = ValueLob.createClobFromReader(in, length);
        return lob;
    }

    public ValueLob createBlob(InputStream stream, int length) throws SQLException {
        ValueLob lob = ValueLob.createBlobFromInputStream(stream, length);
        return lob;
    }

    public void done(Transfer transfer) throws SQLException, IOException {
        transfer.flush();
        int status = transfer.readInt();
        if (status == 0) {
            String sqlstate = transfer.readString();
            String message = transfer.readString();
            int errorCode = transfer.readInt();
            String trace = transfer.readString();
            message = message + "\n" + trace;
            throw new JdbcSQLException(message, sqlstate, errorCode, null);
        }
        if (status == 2) {
            this.transferList = null;
        }
    }

    public boolean isClustered() {
        return this.transferList.size() > 1;
    }

    public boolean isClosed() {
        return this.transferList == null || this.transferList.size() == 0;
    }

    public void traceOperation(String operation, int id) {
        if (this.trace.debug()) {
            this.trace.debug(operation + " " + id);
        }
    }
}

