/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.FileUtils;
import org.h2.util.StringUtils;

public class ConnectionInfo {
    private String originalURL;
    private String url;
    private Properties prop = new Properties();
    private String user;
    private byte[] filePasswordHash;
    private byte[] userPasswordHash;
    private String name;
    private boolean remote;
    private boolean ssl;
    private boolean persistent;

    public ConnectionInfo(String name) {
        this.name = name;
        this.parseName();
    }

    public ConnectionInfo(String u, Properties info) throws SQLException {
        this.originalURL = u;
        this.url = u;
        this.readProperties(info);
        this.readSettings();
        this.readUser();
        this.readPasswords();
        this.name = this.url.substring("jdbc:h2:".length());
        this.parseName();
    }

    private void parseName() {
        if (this.name.equals(".")) {
            this.name = "mem:";
        }
        if (this.name.startsWith("tcp:")) {
            this.remote = true;
            this.name = this.name.substring("tcp:".length());
        } else if (this.name.startsWith("ssl:")) {
            this.remote = true;
            this.ssl = true;
            this.name = this.name.substring("ssl:".length());
        } else if (this.name.startsWith("mem:")) {
            this.persistent = false;
        } else if (this.name.startsWith("file:")) {
            this.name = this.name.substring("file:".length());
            this.persistent = true;
        } else {
            this.persistent = true;
        }
    }

    public String getDatabaseName() {
        if (this.remote) {
            if (this.ssl) {
                return "ssl:" + this.name;
            }
            return "tcp:" + this.name;
        }
        if (this.persistent) {
            return "file:" + this.name;
        }
        return this.name;
    }

    public void setBaseDir(String dir) {
        if (this.persistent) {
            this.name = dir + System.getProperty("file.separator") + this.name;
        }
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    private void readProperties(Properties info) throws SQLException {
        Object[] list = new Object[info.size()];
        info.keySet().toArray(list);
        for (int i = 0; i < list.length; ++i) {
            String key = list[i].toString().toUpperCase();
            if (this.prop.containsKey(key)) {
                throw Message.getSQLException(90066, key);
            }
            this.prop.put(key, info.get(list[i]));
        }
    }

    private void readSettings() throws SQLException {
        int idx = this.url.indexOf(59);
        if (idx >= 0) {
            String settings = this.url.substring(idx + 1);
            this.url = this.url.substring(0, idx);
            String[] list = StringUtils.arraySplit(settings, ';');
            for (int i = 0; i < list.length; ++i) {
                String setting = list[i];
                int equal = setting.indexOf(61);
                if (equal < 0) {
                    throw this.getFormatException();
                }
                String value = setting.substring(equal + 1);
                String key = setting.substring(0, equal);
                String old = this.prop.getProperty(key = key.toUpperCase());
                if (old != null && !old.equals(value)) {
                    throw Message.getSQLException(90066, key);
                }
                this.prop.setProperty(key, value);
            }
        }
    }

    private char[] removePassword() {
        Object p = this.prop.remove("PASSWORD");
        if (p == null) {
            return new char[0];
        }
        if (p instanceof char[]) {
            return (char[])p;
        }
        return p.toString().toCharArray();
    }

    private void readUser() {
        this.user = this.prop.getProperty("USER", "").toUpperCase();
        this.prop.remove("USER");
    }

    void readPasswords() throws SQLException {
        char[] password = this.removePassword();
        SHA256 sha = new SHA256();
        if (this.prop.getProperty("CIPHER") != null) {
            int space = -1;
            for (int i = 0; i < password.length; ++i) {
                if (password[i] != ' ') continue;
                space = i;
                break;
            }
            if (space < 0) {
                throw Message.getSQLException(90050);
            }
            char[] np = new char[password.length - space - 1];
            char[] filePassword = new char[space];
            System.arraycopy(password, space + 1, np, 0, np.length);
            System.arraycopy(password, 0, filePassword, 0, space);
            Arrays.fill(password, '\u0000');
            password = np;
            this.filePasswordHash = sha.getKeyPasswordHash("file", filePassword);
        }
        this.userPasswordHash = sha.getKeyPasswordHash(this.user, password);
    }

    public boolean removeProperty(String key, boolean defaultValue) {
        boolean value = defaultValue;
        String x = (String)this.prop.remove(key);
        if (x != null) {
            value = Boolean.valueOf(x);
        }
        return value;
    }

    public String removeProperty(String key, String defaultValue) {
        String value = defaultValue;
        String x = (String)this.prop.remove(key);
        if (x != null) {
            value = x;
        }
        return value;
    }

    public String getName() throws SQLException {
        if (this.persistent) {
            return FileUtils.normalize(this.name);
        }
        return this.name;
    }

    public byte[] getFilePasswordHash() {
        return this.filePasswordHash;
    }

    public String getUserName() {
        return this.user;
    }

    public byte[] getUserPasswordHash() {
        return this.userPasswordHash;
    }

    public String[] getKeys() {
        String[] keys = new String[this.prop.size()];
        this.prop.keySet().toArray(keys);
        return keys;
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public boolean isSSL() {
        return this.ssl;
    }

    public void setUserName(String name) {
        this.user = name;
    }

    public void setUserPasswordHash(byte[] bs) {
        this.userPasswordHash = bs;
    }

    public void setFilePasswordHash(byte[] bs) {
        this.filePasswordHash = bs;
    }

    public void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalURL;
    }

    public void setOriginalURL(String url) {
        this.originalURL = url;
    }

    int getFileLockMethod() throws JdbcSQLException {
        String method = this.removeProperty("FILE_LOCK", null);
        if (method == null || method.equalsIgnoreCase("FILE")) {
            return 1;
        }
        if (method.equalsIgnoreCase("NO")) {
            return 0;
        }
        if (method.equalsIgnoreCase("SOCKET")) {
            return 2;
        }
        throw Message.getSQLException(90060, method);
    }

    boolean getTextStorage() throws SQLException {
        String storage = this.removeProperty("STORAGE", "BINARY");
        if ("BINARY".equalsIgnoreCase(storage)) {
            return false;
        }
        if ("TEXT".equalsIgnoreCase(storage)) {
            return true;
        }
        throw Message.getInvalidValueException(storage, "storage");
    }

    public SQLException getFormatException() {
        String format = "jdbc:h2:{ {.|mem:}[name] | [file:]fileName | {tcp|ssl}:[//]server[:port][,server2[:port]]/name }[;key=value...]";
        return Message.getSQLException(90046, new String[]{format, this.url}, null);
    }
}

