/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import org.h2.compress.Compresser;

public class CompressLZF
implements Compresser {
    static final int HLOG = 14;
    static final int HASH_SIZE = 16384;
    static final int MAX_LITERAL = 32;
    static final int MAX_OFF = 8192;
    static final int MAX_REF = 264;
    private int[] hashTab;
    private static int[] empty = new int[16384];

    public void setOptions(String options) {
    }

    public int getAlgorithm() {
        return 1;
    }

    int first(byte[] in, int inPos) {
        return (in[inPos] << 8) + (in[inPos + 1] & 0xFF);
    }

    int next(int v, byte[] in, int inPos) {
        return (v << 8) + (in[inPos + 2] & 0xFF);
    }

    int hash(int h) {
        return h * 184117 >> 9 & 0x3FFF;
    }

    public int compress(byte[] in, byte[] out, int outPos) {
        int inLen = in.length;
        if (this.hashTab == null) {
            this.hashTab = new int[16384];
        } else {
            System.arraycopy(empty, 0, this.hashTab, 0, 16384);
        }
        int inPos = 0;
        int literals = 0;
        int hval = this.first(in, inPos);
        while (true) {
            if (inPos < inLen - 4) {
                hval = this.next(hval, in, inPos);
                int off = this.hash(hval);
                int ref = this.hashTab[off];
                this.hashTab[off] = inPos;
                off = inPos - ref - 1;
                if (off < 8192 && ref > 0 && in[ref + 2] == in[inPos + 2] && in[ref + 1] == in[inPos + 1] && in[ref] == in[inPos]) {
                    int len;
                    int maxlen = inLen - inPos - 2;
                    maxlen = maxlen > 264 ? 264 : maxlen;
                    for (len = 3; len < maxlen && in[ref + len] == in[inPos + len]; ++len) {
                    }
                    len -= 2;
                    if (literals != 0) {
                        out[outPos++] = (byte)(literals - 1);
                        literals = -literals;
                        do {
                            out[outPos++] = in[inPos + literals++];
                        } while (literals != 0);
                    }
                    if (len < 7) {
                        out[outPos++] = (byte)((off >> 8) + (len << 5));
                    } else {
                        out[outPos++] = (byte)((off >> 8) + 224);
                        out[outPos++] = (byte)(len - 7);
                    }
                    out[outPos++] = (byte)off;
                    hval = this.first(in, inPos += len);
                    hval = this.next(hval, in, inPos);
                    this.hashTab[this.hash((int)hval)] = inPos++;
                    hval = this.next(hval, in, inPos);
                    this.hashTab[this.hash((int)hval)] = inPos++;
                    continue;
                }
            } else if (inPos == inLen) break;
            ++inPos;
            if (++literals != 32) continue;
            out[outPos++] = (byte)(literals - 1);
            literals = -literals;
            do {
                out[outPos++] = in[inPos + literals++];
            } while (literals != 0);
        }
        if (literals != 0) {
            out[outPos++] = (byte)(literals - 1);
            literals = -literals;
            do {
                out[outPos++] = in[inPos + literals++];
            } while (literals != 0);
        }
        return outPos;
    }

    public void expand(byte[] in, int inPos, byte[] out, int outLen) {
        int outPos = 0;
        do {
            int ctrl;
            if ((ctrl = in[inPos++] & 0xFF) < 32) {
                ctrl += inPos;
                do {
                    out[outPos++] = in[inPos];
                } while (inPos++ < ctrl);
                continue;
            }
            int len = ctrl >> 5;
            int ref = -((ctrl & 0x1F) << 8) - 1;
            if (len == 7) {
                len += in[inPos++] & 0xFF;
            }
            int n = inPos++;
            len += outPos + 2;
            out[outPos] = out[outPos++ + (ref -= in[n] & 0xFF)];
            out[outPos] = out[outPos++ + ref];
            while (outPos < len - 8) {
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
                out[outPos] = out[outPos++ + ref];
            }
            while (outPos < len) {
                out[outPos] = out[outPos++ + ref];
            }
        } while (outPos < outLen);
    }
}

