/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptBase;
import org.h2.message.Message;
import org.h2.util.StringUtils;

public class RunScript
extends ScriptBase {
    private String charset = StringUtils.getDefaultCharset();

    public RunScript(Parser parser) {
        super(parser);
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        int count = 0;
        try {
            String line;
            this.openInput();
            InputStreamReader r = new InputStreamReader(this.in, this.charset);
            LineNumberReader reader = new LineNumberReader(r);
            String lastLine = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if (lastLine != null) {
                    line = lastLine + "\n" + line;
                }
                if (line.endsWith(";")) {
                    line = line.substring(0, line.length() - 1);
                    this.execute(line);
                    lastLine = null;
                    ++count;
                    continue;
                }
                lastLine = line;
            }
            reader.close();
            ((Reader)r).close();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
        finally {
            this.closeIO();
        }
        return count;
    }

    private void execute(String sql) throws SQLException {
        Prepared command = this.session.prepare(sql);
        command.update();
        if (this.session.getAutoCommit()) {
            this.session.commit();
        }
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

