/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.message.Message;
import org.h2.table.Table;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;

    public DropTable(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        Table table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (table == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(42102, this.tableName);
            }
        } else {
            this.session.getUser().checkRight(table, 15);
            table.lock(this.session, true);
            table.setModified();
            if (table.getTemporary() && !table.getGlobalTemporary()) {
                this.session.removeLocalTempTable(table);
            } else {
                db.removeSchemaObject(this.session, table);
            }
        }
        return 0;
    }
}

