/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.engine.Sequence;
import org.h2.message.Message;

public class DropSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifExists;

    public DropSequence(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit();
        Database db = this.session.getDatabase();
        Sequence sequence = this.getSchema().findSequence(this.sequenceName);
        if (sequence == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90036, this.sequenceName);
            }
        } else {
            if (sequence.getBelongsToTable()) {
                throw Message.getSQLException(90082, this.sequenceName);
            }
            db.removeSchemaObject(this.session, sequence);
        }
        return 0;
    }
}

