/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.table.Column;
import org.h2.table.Table;

public class CreateIndex
extends SchemaCommand {
    private String tableName;
    private String indexName;
    private String[] columnNames;
    private boolean primaryKey;
    private boolean unique;
    private boolean hash;

    public CreateIndex(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        boolean persistent = db.isPersistent();
        Table table = this.getSchema().getTableOrView(this.session, this.tableName);
        this.session.getUser().checkRight(table, 15);
        table.lock(this.session, true);
        if (!table.isPersistent()) {
            persistent = false;
        }
        int id = this.getObjectId(true, false);
        if (this.indexName == null) {
            this.indexName = this.getSchema().getUniqueIndexName("INDEX_");
        }
        if (this.getSchema().findIndex(this.indexName) != null) {
            throw Message.getSQLException(42111, this.indexName);
        }
        IndexType indexType = this.primaryKey ? IndexType.createPrimaryKey(persistent, this.hash) : (this.unique ? IndexType.createUnique(persistent, this.hash) : IndexType.createNonUnique(persistent));
        Column[] columns = table.getColumns(this.columnNames);
        table.addIndex(this.session, this.indexName, id, columns, indexType, this.headPos);
        return 0;
    }

    public void setPrimaryKey(boolean b) {
        this.primaryKey = b;
    }

    public void setUnique(boolean b) {
        this.unique = b;
    }

    public void setHash(boolean b) {
        this.hash = b;
    }

    public boolean getHash() {
        return this.hash;
    }
}

