/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class CommandContainer
extends Command {
    private Prepared prepared;

    CommandContainer(Parser parser, Prepared prepared) {
        super(parser);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    public ObjectArray getParameters() {
        return this.prepared.getParameters();
    }

    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() throws SQLException {
        if (this.prepared == null || this.prepared.needRecompile()) {
            this.prepared.setModificationId(0);
            String sql = this.prepared.getSQL();
            ObjectArray oldValues = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parseOnly(sql);
            int mod = this.prepared.getModificationId();
            this.prepared.setModificationId(0);
            ObjectArray newParams = this.prepared.getParameters();
            for (int i = 0; i < newParams.size(); ++i) {
                Value v = ((Expression)oldValues.get(i)).getValue(this.session);
                Parameter p = (Parameter)newParams.get(i);
                p.setValue(v);
            }
            this.prepared.prepare();
            this.prepared.setModificationId(mod);
        }
    }

    public int update() throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        this.prepared.trace();
        return this.prepared.update();
    }

    public LocalResult query(int maxrows) throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        this.prepared.trace();
        return this.prepared.query(maxrows);
    }
}

