/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfReader;
import org.jpedal.objects.raw.PdfDictionary;

public class PdfArrayIterator {
    public static final int TYPE_INTEGER = 1;
    byte[][] rawData = null;
    boolean hasHexChars = false;
    int tokenCount = 0;
    int currentToken = 0;
    int spaceChar = -1;

    public PdfArrayIterator(byte[][] byArray) {
        this.rawData = byArray;
        if (byArray != null) {
            this.tokenCount = byArray.length;
        }
    }

    public PdfArrayIterator(String string) {
        byte[][] byArrayArray = new byte[][]{string.getBytes()};
        this.tokenCount = 1;
    }

    public boolean hasMoreTokens() {
        return this.currentToken < this.tokenCount;
    }

    public int getNextValueType() {
        if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
            return -1;
        }
        byte by = this.rawData[this.currentToken][0];
        if (by > 47 && by < 58) {
            return 1;
        }
        return -1;
    }

    public String getNextValueAsFontChar(int n) {
        String string = "";
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            int n2 = this.rawData[this.currentToken].length - 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.rawData[this.currentToken], 1, byArray, 0, n2);
            string = new String(byArray);
            string = StandardFonts.convertNumberToGlyph(string);
            char c = string.charAt(0);
            if (c == 'B' | c == 'c' | c == 'C' | c == 'G') {
                int n3 = 1;
                int n4 = string.length();
                while (!this.hasHexChars && n3 < n4) {
                    this.hasHexChars = Character.isLetter(string.charAt(n3++));
                }
            }
            if (byArray.length == 5 && byArray[0] == 115 && byArray[1] == 112 && byArray[2] == 97 && byArray[3] == 99 && byArray[4] == 101) {
                this.spaceChar = n;
            }
            ++this.currentToken;
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return string;
    }

    public int getNextValueAsInteger() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            ++this.currentToken;
            return PdfReader.parseInt(0, byArray.length, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getNextValueAsConstant(boolean bl) {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            if (bl) {
                ++this.currentToken;
            }
            return PdfDictionary.getIntKey(1, byArray.length - 1, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }

    public int getSpaceChar() {
        return this.spaceChar;
    }

    public boolean hasHexChars() {
        return this.hasHexChars;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public String getNextValueAsString(boolean bl) {
        String string = "";
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            string = new String(byArray);
            if (bl) {
                ++this.currentToken;
            }
        } else {
            throw new RuntimeException("Out of range exception with PdfArrayIterator");
        }
        return string;
    }

    public int getNextValueAsKey() {
        if (this.currentToken < this.tokenCount) {
            if (this.rawData == null || this.rawData[this.currentToken] == null || this.rawData[this.currentToken].length == 0) {
                throw new RuntimeException("NullValue exception with PdfArrayIterator");
            }
            byte[] byArray = this.rawData[this.currentToken];
            ++this.currentToken;
            return PdfDictionary.getIntKey(0, byArray.length, byArray);
        }
        throw new RuntimeException("Out of range exception with PdfArrayIterator");
    }
}

