/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.text.extractheadlines;

import java.io.File;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.text.ExtractTextInRectangle;
import org.jpedal.examples.text.extractheadlines.HeadlineConfiguration;
import org.jpedal.examples.text.extractheadlines.Output;
import org.jpedal.exception.PdfException;
import org.jpedal.exception.PdfSecurityException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.utils.LogWriter;

public class ExtractHeadlines
extends ExtractTextInRectangle {
    private static final boolean debug = false;
    Output currentOutput = new Output();
    private String configDir = "config" + System.getProperty("file.separator");
    HeadlineConfiguration config = new HeadlineConfiguration(this.configDir);
    private static String testFile = "timesPDFS";
    String[] sectionTokens = null;
    private int[] x1;
    private int[] x2;
    private int[] y1;
    private int[] y2;

    public static void main(String[] stringArray) {
        showMessages = false;
        if (showMessages) {
            System.out.println("Simple demo to extract text objects");
        }
        String string = testFile;
        if (stringArray.length == 1) {
            string = stringArray[0];
            System.out.println("File :" + string);
        } else {
            System.out.println("Please call with Filename");
            System.exit(1);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        ExtractHeadlines extractHeadlines = new ExtractHeadlines(string);
    }

    private String extractSection(String string) {
        if (showMessages) {
            System.out.println(string);
        }
        if (string == null) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.sectionTokens.length;
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.sectionTokens[i], "x");
        }
        Object var4_5 = null;
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<>");
        while (stringTokenizer.hasMoreTokens() && (string2 == null || var4_5 == null)) {
            string3 = stringTokenizer.nextToken();
            if (hashMap.get(string3) == null) continue;
            String string4 = string3;
            string3 = stringTokenizer.nextToken();
            boolean bl = false;
            if (bl || string3.length() <= 2) continue;
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens() && !string3.equals("/font")) {
                if (string3.indexOf("SpaceC") != -1) {
                    stringBuffer.append(' ');
                } else {
                    stringBuffer.append(string3);
                }
                string3 = stringTokenizer.nextToken();
            }
            string2 = stringBuffer.toString().trim();
            if (!string4.equals("font face=\"TimesClassicDisplay\" style=\"font-size:16pt\"")) continue;
            break;
        }
        return string2;
    }

    public ExtractHeadlines(String string) {
        File file;
        Object object;
        int n = Integer.parseInt(this.config.getValue("xmlCount"));
        this.sectionTokens = new String[n];
        for (int i = 0; i < n; ++i) {
            this.sectionTokens[i] = this.config.getValue("xmlTag_" + i);
            if (!showMessages) continue;
            System.out.println(this.sectionTokens[i]);
        }
        n = Integer.parseInt(this.config.getValue("locationCount"));
        this.x1 = new int[n];
        this.x2 = new int[n];
        this.y1 = new int[n];
        this.y2 = new int[n];
        String string2 = "locTag";
        String[] stringArray = new String[]{"x1", "y1", "x2", "y2"};
        for (int i = 0; i < n; ++i) {
            block10: for (int j = 0; j < 4; ++j) {
                object = string2 + '_' + i + '_' + stringArray[j];
                String string3 = this.config.getValue((String)object);
                int n2 = Integer.parseInt(string3);
                switch (j) {
                    case 0: {
                        this.x1[i] = n2;
                        continue block10;
                    }
                    case 1: {
                        this.y1[i] = n2;
                        continue block10;
                    }
                    case 2: {
                        this.x2[i] = n2;
                        continue block10;
                    }
                    case 3: {
                        this.y2[i] = n2;
                    }
                }
            }
        }
        if (!this.user_dir.endsWith(this.separator)) {
            this.user_dir = this.user_dir + this.separator;
        }
        if (!(file = new File(this.outputDir)).exists()) {
            file.mkdirs();
        }
        if (string.toLowerCase().endsWith(".pdf")) {
            this.decodeFile("", string);
        } else {
            String[] stringArray2 = null;
            object = null;
            if (!string.endsWith(this.separator)) {
                string = string + this.separator;
            }
            try {
                object = new File(string);
                if (!((File)object).isDirectory()) {
                    System.err.println(string + " is not a directory. Exiting program");
                }
                stringArray2 = ((File)object).list();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception trying to access file " + exception.getMessage());
            }
            long l = stringArray2.length;
            int n3 = 0;
            while ((long)n3 < l) {
                if (showMessages) {
                    System.out.println(n3 + "/ " + l + ' ' + stringArray2[n3]);
                }
                if (stringArray2[n3].toLowerCase().endsWith(".pdf")) {
                    if (showMessages) {
                        System.out.println(string + stringArray2[n3]);
                    }
                    this.decodeFile(string, stringArray2[n3]);
                }
                ++n3;
            }
        }
    }

    protected void decodeFile(String string, String string2) {
        String string3 = string + string2;
        String string4 = string2.substring(0, 3);
        String string5 = string2.substring(3, 5);
        String string6 = string2.substring(5, 8);
        String string7 = string2.substring(8, 10);
        String string8 = "TimesSections/";
        File file = new File(string8);
        file.mkdir();
        this.currentOutput.open(string8 + string4 + '.' + string6 + '.' + string7 + ".txt");
        String string9 = null;
        try {
            this.decodePdf = new PdfDecoder(false);
            this.decodePdf.setExtractionMode(1);
            this.decodePdf.init(true);
            this.decodePdf.openPdfFile(string3);
            if (showMessages) {
                System.out.println("file_name=" + string3);
            }
        }
        catch (PdfSecurityException pdfSecurityException) {
            System.err.println("Security Exception " + pdfSecurityException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (PdfException pdfException) {
            System.err.println("Pdf Exception " + pdfException + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code for text extraction on file " + this.decodePdf.getObjectStore().getCurrentFilename());
            exception.printStackTrace();
        }
        if (this.decodePdf.isEncrypted() && !this.decodePdf.isPasswordSupplied() && !this.decodePdf.isExtractionAllowed()) {
            if (showMessages) {
                System.out.println("Encrypted settings");
                System.out.println("Please look at SimpleViewer for code sample to handle such files");
                System.out.println("Or get support/consultancy");
            }
        } else {
            int n = 1;
            int n2 = this.decodePdf.getPageCount();
            int n3 = this.x2.length;
            string9 = null;
            try {
                for (int i = n; i < n2 + 1; ++i) {
                    this.decodePdf.decodePage(i);
                    for (int j = 0; j < n3; ++j) {
                        int n4 = this.x1[j];
                        int n5 = this.x2[j];
                        int n6 = this.y1[j];
                        int n7 = this.y2[j];
                        if (showMessages) {
                            System.out.println("Using (" + n4 + ',' + n6 + ") (" + n5 + ',' + n7 + ')');
                        }
                        PdfGroupingAlgorithms pdfGroupingAlgorithms = this.decodePdf.getGroupingObject();
                        this.text = null;
                        try {
                            this.text = pdfGroupingAlgorithms.extractTextInRectangle(n4, n6, n5, n7, i, false, true);
                        }
                        catch (PdfException pdfException) {
                            this.decodePdf.closePdfFile();
                            System.err.println("Exception " + pdfException.getMessage() + " in file " + this.decodePdf.getObjectStore().fullFileName);
                            pdfException.printStackTrace();
                        }
                        if (this.text == null) {
                            if (!showMessages) continue;
                            System.out.println("No text found");
                            continue;
                        }
                        string9 = this.extractSection(this.text);
                        if (string9 == null) continue;
                        j = n3;
                    }
                    this.decodePdf.flushObjectValues(false);
                    if (string9 != null) {
                        if (showMessages) {
                            System.out.println("section=" + string9);
                        }
                        this.currentOutput.outputSection(string9, string5, string2);
                    }
                    if (!showMessages) continue;
                    System.out.println("----");
                }
            }
            catch (Exception exception) {
                this.decodePdf.closePdfFile();
                exception.printStackTrace();
                System.out.println(this.decodePdf.getObjectStore().getCurrentFilename());
            }
            this.decodePdf.flushObjectValues(true);
            if (showMessages) {
                System.out.println("Text read");
            }
        }
        this.currentOutput.close();
        this.decodePdf.closePdfFile();
    }
}

