/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash.encoder;

import com.carbonfive.flash.Context;
import com.carbonfive.flash.encoder.ActionScriptEncoder;
import com.carbonfive.flash.encoder.ArrayEncoder;
import com.carbonfive.flash.encoder.EncoderFactory;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ArrayEncoderTest
extends TestCase {
    private EncoderFactory factory = null;
    static /* synthetic */ Class class$com$carbonfive$flash$encoder$ArrayEncoderTest;

    public ArrayEncoderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$com$carbonfive$flash$encoder$ArrayEncoderTest == null ? (class$com$carbonfive$flash$encoder$ArrayEncoderTest = ArrayEncoderTest.class$("com.carbonfive.flash.encoder.ArrayEncoderTest")) : class$com$carbonfive$flash$encoder$ArrayEncoderTest);
        return suite;
    }

    protected void setUp() throws Exception {
        this.factory = EncoderFactory.getInstance();
    }

    protected void tearDown() throws Exception {
        this.factory = null;
    }

    public void testObjectArrayToArrayListEncode() {
        Object obj1 = new Object();
        Object obj2 = new Object();
        Object[] array = new Object[]{obj1, obj2};
        ActionScriptEncoder encoder = this.factory.getEncoder(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encoder);
        Object encodedObject = encoder.encodeObject(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encodedObject);
        ArrayEncoderTest.assertTrue((boolean)(encodedObject instanceof ArrayList));
        ArrayList list = (ArrayList)encodedObject;
        ArrayEncoderTest.assertEquals((int)2, (int)list.size());
        ArrayEncoderTest.assertEquals((Object)obj1, list.get(0));
        ArrayEncoderTest.assertEquals((Object)obj2, list.get(1));
    }

    public void testIntegerArrayToArrayListEncode() {
        Integer int1 = new Integer(1);
        Integer int2 = new Integer(2);
        Integer[] array = new Integer[]{int1, int2};
        Double dbl1 = new Double(int1.intValue());
        Double dbl2 = new Double(int2.intValue());
        ActionScriptEncoder encoder = this.factory.getEncoder(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encoder);
        Object encodedObject = encoder.encodeObject(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encodedObject);
        ArrayEncoderTest.assertTrue((boolean)(encodedObject instanceof ArrayList));
        ArrayList list = (ArrayList)encodedObject;
        ArrayEncoderTest.assertEquals((int)2, (int)list.size());
        ArrayEncoderTest.assertTrue((boolean)(list.get(0) instanceof Double));
        ArrayEncoderTest.assertTrue((boolean)(list.get(1) instanceof Double));
        ArrayEncoderTest.assertEquals((Object)dbl1, list.get(0));
        ArrayEncoderTest.assertEquals((Object)dbl2, list.get(1));
    }

    public void testIntArrayToArrayListEncode() throws Exception {
        int[] array = new int[]{1, 2, 3};
        ActionScriptEncoder encoder = this.factory.getEncoder(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encoder);
        Object encodedObject = encoder.encodeObject(Context.getBaseContext(), array);
        ArrayEncoderTest.assertNotNull((Object)encodedObject);
        ArrayEncoderTest.assertTrue((boolean)(encodedObject instanceof ArrayList));
        ArrayList list = (ArrayList)encodedObject;
        ArrayEncoderTest.assertEquals((int)3, (int)list.size());
        ArrayEncoderTest.assertEquals((Object)new Double(1.0), list.get(0));
        ArrayEncoderTest.assertEquals((Object)new Double(2.0), list.get(1));
        ArrayEncoderTest.assertEquals((Object)new Double(3.0), list.get(2));
    }

    public void testNullEntry() throws Exception {
        String[] array = new String[]{"1", null};
        ArrayEncoder encoder = new ArrayEncoder();
        Object encoded = encoder.encodeObject(Context.getBaseContext(), array);
        ArrayEncoderTest.assertTrue((boolean)(encoded instanceof ArrayList));
        ArrayList list = (ArrayList)encoded;
        ArrayEncoderTest.assertEquals((Object)"1", list.get(0));
        ArrayEncoderTest.assertNull(list.get(1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

