/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.flash.decoder;

import com.carbonfive.flash.decoder.CollectionDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CollectionDecoderTest
extends TestCase {
    static /* synthetic */ Class class$com$carbonfive$flash$decoder$CollectionDecoderTest;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Collection;

    public CollectionDecoderTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(class$com$carbonfive$flash$decoder$CollectionDecoderTest == null ? (class$com$carbonfive$flash$decoder$CollectionDecoderTest = CollectionDecoderTest.class$("com.carbonfive.flash.decoder.CollectionDecoderTest")) : class$com$carbonfive$flash$decoder$CollectionDecoderTest);
        return suite;
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testDecodeObject() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        CollectionDecoder decoder = new CollectionDecoder();
        CollectionDecoderTest.assertTrue((boolean)(decoder.decodeObject(list, class$java$util$List == null ? (class$java$util$List = CollectionDecoderTest.class$("java.util.List")) : class$java$util$List) instanceof ArrayList));
        CollectionDecoderTest.assertTrue((boolean)(decoder.decodeObject(list, class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionDecoderTest.class$("java.util.ArrayList")) : class$java$util$ArrayList) instanceof ArrayList));
        CollectionDecoderTest.assertTrue((boolean)(decoder.decodeObject(list, class$java$util$Set == null ? (class$java$util$Set = CollectionDecoderTest.class$("java.util.Set")) : class$java$util$Set) instanceof HashSet));
        CollectionDecoderTest.assertTrue((boolean)(decoder.decodeObject(list, class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionDecoderTest.class$("java.util.HashSet")) : class$java$util$HashSet) instanceof HashSet));
        CollectionDecoderTest.assertTrue((boolean)(decoder.decodeObject(list, class$java$util$Collection == null ? (class$java$util$Collection = CollectionDecoderTest.class$("java.util.Collection")) : class$java$util$Collection) instanceof ArrayList));
    }

    public void testDecodeIntegerCollection() throws Exception {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(new Double(1.0));
        list.add(new Double(2.0));
        CollectionDecoder decoder = new CollectionDecoder();
        List list2 = (List)decoder.decodeObject(list, class$java$util$Collection == null ? (class$java$util$Collection = CollectionDecoderTest.class$("java.util.Collection")) : class$java$util$Collection);
        CollectionDecoderTest.assertTrue((boolean)(list2.get(0) instanceof Integer));
        CollectionDecoderTest.assertTrue((boolean)(list2.get(1) instanceof Integer));
        CollectionDecoderTest.assertEquals(Arrays.asList(new Integer(1), new Integer(2)), (Object)list2);
        list = new ArrayList();
        list.add(new Double(1.5));
        list.add(new Double(2.0));
        list2 = (List)decoder.decodeObject(list, class$java$util$Collection == null ? (class$java$util$Collection = CollectionDecoderTest.class$("java.util.Collection")) : class$java$util$Collection);
        CollectionDecoderTest.assertTrue((boolean)(list2.get(0) instanceof Double));
        CollectionDecoderTest.assertTrue((boolean)(list2.get(1) instanceof Double));
        CollectionDecoderTest.assertEquals(Arrays.asList(new Double(1.5), new Double(2.0)), (Object)list2);
    }

    public void testNullEntry() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add(null);
        CollectionDecoder decoder = new CollectionDecoder();
        List list2 = (List)decoder.decodeObject(list, class$java$util$Collection == null ? (class$java$util$Collection = CollectionDecoderTest.class$("java.util.Collection")) : class$java$util$Collection);
        CollectionDecoderTest.assertTrue((boolean)(list2.get(0) instanceof String));
        CollectionDecoderTest.assertEquals((Object)"1", list2.get(0));
        CollectionDecoderTest.assertNull(list2.get(1));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

