/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.security.sasl.preview.RealmCallback;
import com.sun.security.sasl.preview.RealmChoiceCallback;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

final class DefaultCallbackHandler
implements CallbackHandler {
    private char[] passwd;
    private String authenticationID;
    private String authRealm;

    DefaultCallbackHandler(String string, Object object, String string2) throws IOException {
        this.authenticationID = string;
        this.authRealm = string2;
        if (object instanceof String) {
            this.passwd = ((String)object).toCharArray();
        } else if (object instanceof char[]) {
            this.passwd = (char[])((char[])object).clone();
        } else if (object != null) {
            String string3 = new String((byte[])object, "UTF8");
            this.passwd = string3.toCharArray();
        }
    }

    void clearPassword() {
        if (this.passwd != null) {
            int n = 0;
            while (n < this.passwd.length) {
                this.passwd[n] = '\u0000';
                ++n;
            }
            this.passwd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.clearPassword();
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n = 0;
        while (n < callbackArray.length) {
            if (callbackArray[n] instanceof NameCallback) {
                ((NameCallback)callbackArray[n]).setName(this.authenticationID);
            } else if (callbackArray[n] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[n]).setPassword(this.passwd);
            } else if (callbackArray[n] instanceof RealmChoiceCallback) {
                String[] stringArray = ((RealmChoiceCallback)callbackArray[n]).getChoices();
                int n2 = 0;
                if (this.authRealm != null) {
                    n2 = -1;
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].equals(this.authRealm)) {
                            n2 = n3;
                        }
                        ++n3;
                    }
                    if (n2 == -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            stringBuffer.append(String.valueOf(stringArray[n4]) + ",");
                            ++n4;
                        }
                        throw new IllegalArgumentException("Cannot match 'java.naming.security.sasl.realm' property value, '" + this.authRealm + "' with choices " + stringBuffer + "in RealmChoiceCallback");
                    }
                }
                ((RealmChoiceCallback)callbackArray[n]).setSelectedIndex(n2);
            } else if (callbackArray[n] instanceof RealmCallback) {
                if (this.authRealm != null) {
                    ((RealmCallback)callbackArray[n]).setText(this.authRealm);
                } else {
                    ((RealmCallback)callbackArray[n]).setText("");
                }
            } else {
                throw new UnsupportedCallbackException(callbackArray[n]);
            }
            ++n;
        }
    }
}

