/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.util.CacheManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ByteCache {
    private static final Logger logger = Logger.getLogger(ByteCache.class.toString());
    private int length = 0;
    private File tempFile = null;
    private boolean isCached = false;
    private static int fileCachingSize;
    private static int fileCachingFallbackSize;
    private static boolean isCachingEnabled;
    private FileOutputStream fileOutputStream = null;
    private FileInputStream fileInputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private CacheManager cacheManager = null;

    public ByteCache(byte[] byArray, Library library) {
        this.cacheManager = library.getCacheManager();
        try {
            int n;
            int n2 = n = byArray == null ? 0 : byArray.length;
            if (n <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(n);
            OutputStream outputStream = this.getCorrectOutputStream(n);
            outputStream.write(byArray);
            this.length = n;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error creating ByteCache temporary file.", iOException);
        }
    }

    public ByteCache(int n, Library library) {
        this.cacheManager = library.getCacheManager();
        try {
            if (n <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(n);
            this.getCorrectOutputStream(n);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error creating ByteCache temporary file.", iOException);
        }
    }

    public void writeBytes(InputStream inputStream, int n) {
        try {
            int n2;
            int n3;
            int n4;
            if (n <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(n);
            OutputStream outputStream = this.getCorrectOutputStream(n);
            byte[] byArray = new byte[Math.min(n, 4096)];
            for (n3 = 0; n3 < n && (n4 = inputStream.read(byArray, 0, n2 = Math.min(byArray.length, n - n3))) > 0; n3 += n4) {
                outputStream.write(byArray, 0, n4);
            }
            this.length += n3;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error writing to temporary file ", iOException);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        try {
            if (n2 <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(n2);
            OutputStream outputStream = this.getCorrectOutputStream(Math.max(n2, 256));
            outputStream.write(byArray, n, n2);
            this.length += n2;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error writing to temporary file.", iOException);
        }
    }

    public void writeBytes(byte[] byArray) {
        try {
            int n;
            int n2 = n = byArray == null ? 0 : byArray.length;
            if (n <= 0) {
                return;
            }
            this.calcIfFileCachingAndPotentiallyForce(n);
            OutputStream outputStream = this.getCorrectOutputStream(Math.max(n, 256));
            outputStream.write(byArray);
            this.length += n;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error writing to temporary file ", iOException);
        }
    }

    public void writeBytes(int n) {
        try {
            int n2 = 1;
            this.calcIfFileCachingAndPotentiallyForce(n2);
            OutputStream outputStream = this.getCorrectOutputStream(256);
            outputStream.write(n);
            this.length += n2;
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error writing to temporary file ", iOException);
        }
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        int n3 = -1;
        try {
            InputStream inputStream = this.getCorrectInputStream();
            if (inputStream != null) {
                n3 = inputStream.read(byArray, n, n2);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error reading from temporary file ", iOException);
        }
        return n3;
    }

    public int readBytes(byte[] byArray) {
        int n = -1;
        try {
            InputStream inputStream = this.getCorrectInputStream();
            if (inputStream != null) {
                n = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error reading from temporary file ", iOException);
        }
        return n;
    }

    public int readByte() {
        int n = -1;
        try {
            InputStream inputStream = this.getCorrectInputStream();
            if (inputStream != null) {
                n = inputStream.read();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error reading from temporary file ", iOException);
        }
        return n;
    }

    public void forceByteCaching() {
        if (isCachingEnabled && !this.isCached) {
            try {
                if (this.tempFile == null) {
                    this.createTempFile();
                }
                if (this.fileOutputStream == null) {
                    this.fileOutputStream = new FileOutputStream(this.tempFile);
                }
                if (this.byteArrayOutputStream != null) {
                    this.fileOutputStream.write(this.byteArrayOutputStream.toByteArray());
                }
                this.isCached = true;
                this.byteArrayOutputStream = null;
                this.byteArrayInputStream = null;
            }
            catch (IOException iOException) {
                logger.log(Level.FINE, "Error creating the temp file.", iOException);
            }
        }
    }

    public void dispose(boolean bl) {
        try {
            if (!this.isCached && bl && this.length > fileCachingFallbackSize) {
                this.forceByteCaching();
            }
            if (this.fileOutputStream != null) {
                this.fileOutputStream.flush();
                this.fileOutputStream.close();
                this.fileOutputStream = null;
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
                this.fileInputStream = null;
            }
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.close();
                this.byteArrayInputStream = null;
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.flush();
                this.byteArrayOutputStream.close();
                if (this.isCached || !bl) {
                    this.byteArrayOutputStream = null;
                }
            }
            if (!bl) {
                this.deleteFileCache();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error closing file streams ", iOException);
        }
    }

    public byte[] toByteArray() {
        byte[] byArray = null;
        try {
            if (this.isCached) {
                if (this.tempFile != null) {
                    FileInputStream fileInputStream = new FileInputStream(this.tempFile);
                    byArray = new byte[this.length];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                }
            } else if (this.byteArrayOutputStream != null) {
                byArray = this.byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error reading from temporary file.", iOException);
        }
        return byArray;
    }

    public void deleteFileCache() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    public void close() {
        try {
            if (this.fileOutputStream != null) {
                this.fileOutputStream.close();
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
            }
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.close();
            }
            if (this.byteArrayOutputStream != null) {
                this.byteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error closing file streams.", iOException);
        }
    }

    public void reset() {
        try {
            if (this.byteArrayInputStream != null) {
                this.byteArrayInputStream.reset();
            }
            if (this.fileInputStream != null) {
                this.fileInputStream.close();
                this.fileInputStream = null;
                this.fileInputStream = new FileInputStream(this.tempFile);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error closing file streams.", iOException);
        }
    }

    public boolean isCached() {
        return this.isCached;
    }

    public int getLength() {
        return this.length;
    }

    public boolean inMemory() {
        return this.byteArrayOutputStream != null;
    }

    private void createTempFile() {
        try {
            this.tempFile = File.createTempFile("PDFByteStream" + this.getClass().hashCode(), ".tmp");
            this.tempFile.deleteOnExit();
            this.cacheManager.addCachedFile(this.tempFile.getAbsolutePath());
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "Error creating byte cache tmp file");
        }
    }

    private void calcIfFileCachingAndPotentiallyForce(int n) {
        if (!this.isCached && this.length + n > fileCachingSize) {
            this.forceByteCaching();
        }
    }

    private OutputStream getCorrectOutputStream(int n) throws IOException {
        if (this.isCached) {
            if (this.tempFile == null) {
                this.createTempFile();
            }
            if (this.fileOutputStream == null) {
                this.fileOutputStream = new FileOutputStream(this.tempFile.getAbsolutePath(), true);
            }
            return this.fileOutputStream;
        }
        if (this.byteArrayOutputStream == null) {
            this.byteArrayOutputStream = new ByteArrayOutputStream(n);
        }
        return this.byteArrayOutputStream;
    }

    private InputStream getCorrectInputStream() throws IOException {
        if (this.isCached) {
            if (this.tempFile != null) {
                if (this.fileInputStream == null) {
                    this.fileInputStream = new FileInputStream(this.tempFile);
                }
                return this.fileInputStream;
            }
        } else if (this.byteArrayOutputStream != null) {
            if (this.byteArrayInputStream == null) {
                this.byteArrayInputStream = new ByteArrayInputStream(this.byteArrayOutputStream.toByteArray());
            }
            return this.byteArrayInputStream;
        }
        return null;
    }

    static {
        fileCachingFallbackSize = 524288;
        fileCachingSize = Defs.sysPropertyInt("org.icepdf.core.streamcache.thresholdSize", 1000000);
        if (fileCachingFallbackSize > fileCachingSize) {
            fileCachingFallbackSize = fileCachingSize;
        }
        isCachingEnabled = Defs.sysPropertyBoolean("org.icepdf.core.streamcache.enabled", true);
    }
}

